/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.config;

import com.ibm.cognos.pdc.core.ehcache.config.ConfigLifeCycleManager;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigProperties;
import com.ibm.cognos.pdc.core.ehcache.config.EhConfigFactoryHelper;
import com.ibm.cognos.pdc.core.ehcache.config.SetterHelper;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCBean;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCCacheBean;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCElementBean;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCGridBean;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.pogo.PDCDispatcher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.FactoryConfiguration;
import org.apache.log.Logger;

public class EhCacheManagerConfigBuilder {
    private static final Logger LOGGER = LogKitFactory.getLogger(EhCacheManagerConfigBuilder.class);
    private static final String DEFAULT_PEER_LISTENER_FACTORY = "com.ibm.cognos.pdc.core.ehcache.CognosCacheManagerPeerListenerFactory";
    private static final String DEFAULT_PEER_PROVIDER_FACTORY = "com.ibm.cognos.pdc.core.ehcache.CognosCacheManagerPeerProviderFactory";
    private static final String DEFAULT_REPLICATOR_FACTORY = "net.sf.ehcache.distribution.RMICacheReplicatorFactory";
    private static final String DEFAULT_BOOTSTRAP_LOADER_FACTORY = "net.sf.ehcache.distribution.RMIBootstrapCacheLoaderFactory";
    private static final String RMI_PORT = "remoteObjectPort";
    private static final String PEER_PORT = "port";
    private static final SetterHelper setterHelper = new SetterHelper(CacheConfiguration.class);
    private static final Set<String> EXPLICIT_ATTRIBUTES = new HashSet<String>();
    private static final EhCacheManagerConfigBuilder INSTANCE;

    public static EhCacheManagerConfigBuilder getInstance() {
        return INSTANCE;
    }

    public Configuration getConfiguration(ConfigLifeCycleManager configManager) {
        PDCBean pdcConfig = configManager.getPDCConfig();
        PDCGridBean[] gridConfigs = configManager.getPDCGridConfigs();
        ConfigProperties cclconfigProps = configManager.getConfigProps();
        Configuration ehConfig = new Configuration();
        ehConfig.setUpdateCheck(false);
        ehConfig.setName(pdcConfig.getName());
        if (this.isReplicationEnabled(cclconfigProps)) {
            this.configurePeerProviderFactory(ehConfig, pdcConfig);
            this.applyConfigProperties(pdcConfig, cclconfigProps);
            this.configurePeerListenerFactory(ehConfig, pdcConfig);
        }
        this.configureGrids(configManager.getLocalDispatcher(), ehConfig, gridConfigs);
        LOGGER.info("Configured CacheManager programmatically");
        return ehConfig;
    }

    private boolean isReplicationEnabled(ConfigProperties cclconfigProps) {
        return Boolean.TRUE.equals(cclconfigProps.get("com.ibm.cognos.pdc.config.enableReplication"));
    }

    private void applyConfigProperties(PDCBean pdcConfig, ConfigProperties cclconfigProps) {
        String rmiPort;
        PDCElementBean configElement = pdcConfig.getPeerListenerFactory();
        String peerPort = String.valueOf(cclconfigProps.get("com.ibm.cognos.pdc.config.peerPort"));
        if (this.isPortValueSet(peerPort)) {
            configElement.setAttribute(PEER_PORT, peerPort);
        }
        if (this.isPortValueSet(rmiPort = String.valueOf(cclconfigProps.get("com.ibm.cognos.pdc.config.rmiPort")))) {
            configElement.setAttribute(RMI_PORT, rmiPort);
        }
    }

    private boolean isPortValueSet(String portValue) {
        return !"null".equals(portValue) && !"0".equals(portValue.trim());
    }

    private void configureGrids(PDCDispatcher dispatcher, Configuration ehConfig, PDCGridBean[] pdcGridConfigs) {
        for (PDCGridBean gridConfig : pdcGridConfigs) {
            CacheConfiguration ehCacheConfig = new CacheConfiguration();
            for (PDCCacheBean pdcCacheConfig : gridConfig.getCaches()) {
                if (!this.isCacheEnabled(dispatcher, pdcCacheConfig)) continue;
                ehCacheConfig.setName(gridConfig.getName() + "." + pdcCacheConfig.getName());
                this.setCacheAttributes(ehCacheConfig, pdcCacheConfig);
                this.configureCacheEventListenerFactory(ehCacheConfig, pdcCacheConfig);
                this.configureBootstrapCacheLoader(ehCacheConfig, pdcCacheConfig);
                this.addCacheToGrid(ehConfig, gridConfig, ehCacheConfig);
                LOGGER.info("adding cache to configuration: " + ehCacheConfig.getName());
            }
        }
    }

    private boolean isCacheEnabled(PDCDispatcher dispatcher, PDCCacheBean pdcCacheConfig) {
        String dependsOnService = pdcCacheConfig.getAttribute("dependsOnService");
        boolean enabled = true;
        if (dependsOnService != null && !dispatcher.getServices().contains(dependsOnService)) {
            LOGGER.info("dependsOnService disables cache: " + pdcCacheConfig.getName());
            enabled = false;
        }
        return enabled;
    }

    private void addCacheToGrid(Configuration ehConfig, PDCGridBean gridConfig, CacheConfiguration ehCacheConfig) {
        if (this.isDefaultGrid(gridConfig)) {
            ehConfig.addDefaultCache(ehCacheConfig);
        } else {
            ehConfig.addCache(ehCacheConfig);
        }
    }

    private boolean isDefaultGrid(PDCGridBean gridConfig) {
        return "default".equals(gridConfig.getName());
    }

    private void setCacheAttributes(CacheConfiguration ehCacheConfig, PDCCacheBean pdcCacheConfig) {
        for (QName attribute : pdcCacheConfig.getAttributes()) {
            String methodName = attribute.getLocalPart();
            if (!this.useDynamicSetter(methodName)) continue;
            String attributeValue = pdcCacheConfig.getAttribute(attribute);
            setterHelper.invokeSetter(ehCacheConfig, methodName, attributeValue);
        }
    }

    private boolean useDynamicSetter(String methodName) {
        return !EXPLICIT_ATTRIBUTES.contains(methodName);
    }

    private void configurePeerListenerFactory(Configuration ehConfig, PDCBean pdcConfig) {
        new EhConfigFactoryHelper<Configuration>(ehConfig, pdcConfig.getPeerListenerFactory(), "addCacheManagerPeerListenerFactory", FactoryConfiguration.class, DEFAULT_PEER_LISTENER_FACTORY).configure();
    }

    private void configurePeerProviderFactory(Configuration ehConfig, PDCBean pdcConfig) {
        new EhConfigFactoryHelper<Configuration>(ehConfig, pdcConfig.getPeerProviderFactory(), "addCacheManagerPeerProviderFactory", FactoryConfiguration.class, DEFAULT_PEER_PROVIDER_FACTORY).configure();
    }

    private void configureBootstrapCacheLoader(CacheConfiguration cacheConfig, PDCCacheBean pdcCacheConfig) {
        new EhConfigFactoryHelper<CacheConfiguration>(cacheConfig, pdcCacheConfig.getCacheEventListenerFactory(), "addBootstrapCacheLoaderFactory", CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration.class, DEFAULT_BOOTSTRAP_LOADER_FACTORY).configure();
    }

    private void configureCacheEventListenerFactory(CacheConfiguration cacheConfig, PDCCacheBean pdcCacheConfig) {
        new EhConfigFactoryHelper<CacheConfiguration>(cacheConfig, pdcCacheConfig.getCacheEventListenerFactory(), "addCacheEventListenerFactory", CacheConfiguration.CacheEventListenerFactoryConfiguration.class, DEFAULT_REPLICATOR_FACTORY).configure();
    }

    static {
        String[] attributes = new String[]{"name", "class", "dependsOnService"};
        EXPLICIT_ATTRIBUTES.addAll(Arrays.asList(attributes));
        INSTANCE = new EhCacheManagerConfigBuilder();
    }
}

