/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.config;

import com.ibm.cognos.pdc.core.ehcache.config.PropertiesRenderer;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCElementBean;
import java.lang.reflect.Method;
import net.sf.ehcache.config.FactoryConfiguration;

class EhConfigFactoryHelper<T> {
    protected T ehConfigObject;
    protected PDCElementBean elementConfig;
    protected String methodName;
    protected Class<?> factoryConfigClass;
    protected String defaultClassName;

    protected EhConfigFactoryHelper(T ehConfigObject, PDCElementBean elementConfig, String methodName, Class<?> factoryConfigClass, String defaultClassName) {
        this.ehConfigObject = ehConfigObject;
        this.elementConfig = elementConfig;
        this.methodName = methodName;
        this.factoryConfigClass = factoryConfigClass;
        this.defaultClassName = defaultClassName;
    }

    protected void configure() {
        if (this.elementConfig != null) {
            try {
                FactoryConfiguration factoryConfig = (FactoryConfiguration)this.factoryConfigClass.newInstance();
                this.updateFactoryConfig(factoryConfig, this.elementConfig, this.defaultClassName);
                this.addFactoryConfig(factoryConfig);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateFactoryConfig(FactoryConfiguration<?> factoryConfig, PDCElementBean elementConfig, String defaultClassName) {
        String className = elementConfig.getAttribute("class");
        if (className == null) {
            className = defaultClassName;
        }
        factoryConfig.className(className);
        PropertiesRenderer renderer = new PropertiesRenderer(elementConfig);
        renderer.exclude("class");
        renderer.exclude("name");
        factoryConfig.setProperties(renderer.asString());
    }

    protected void addFactoryConfig(FactoryConfiguration<?> factoryConfig) {
        try {
            Method method = this.ehConfigObject.getClass().getMethod(this.methodName, factoryConfig.getClass());
            method.invoke(this.ehConfigObject, factoryConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

