/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.config;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.PogoEngineContext;
import com.ibm.cognos.pdc.core.ehcache.config.ResourceLoader;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log.Logger;

public class PogoEngineContextResourceLoader
implements ResourceLoader {
    static final String CONTEXT_RESOURCE_PREFIX = "/WEB-INF/pdc/";
    static final String INSTALL_RESOURCE_PREFIX = "../configuration/cache/pdc/";
    private static final Logger LOGGER = LogKitFactory.getLogger(PogoEngineContextResourceLoader.class);
    private final PogoEngineContext context;
    private final ICCLConfiguration icclConfiguration;
    private final String contextResourcePrefix;
    private final String installResourcePrefix;

    public PogoEngineContextResourceLoader(PogoEngineContext context) {
        this(context, CONTEXT_RESOURCE_PREFIX, INSTALL_RESOURCE_PREFIX, CCLConfigurationFactory.getInstance());
    }

    public PogoEngineContextResourceLoader(PogoEngineContext context, String resourcePrefix, String installResourcePrefix, ICCLConfiguration icclConfiguration) {
        this.context = context;
        this.contextResourcePrefix = resourcePrefix;
        this.installResourcePrefix = installResourcePrefix;
        this.icclConfiguration = icclConfiguration;
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        InputStream in = null;
        in = this.getResourceFromInstallLocation(resource);
        if (in == null) {
            in = this.getResourceFromContext(resource);
        }
        return in;
    }

    private InputStream getResourceFromInstallLocation(String resource) {
        FileInputStream in = null;
        String resourcePath = this.icclConfiguration.resolveEffectivePath(this.installResourcePrefix + resource);
        File resourceFile = new File(resourcePath);
        if (resourceFile.exists()) {
            try {
                in = new FileInputStream(resourceFile);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("getResourceAsStream(" + resourcePath + ") returning: " + in);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.error("getResourceAsStream(" + resourcePath + ") failed", (Throwable)e);
            }
        }
        return in;
    }

    private InputStream getResourceFromContext(String resource) {
        String resourcePath = this.contextResourcePrefix + resource;
        InputStream in = this.context.getResourceAsStream(resourcePath);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getResourceAsStream(" + resourcePath + ") returning: " + in);
        }
        return in;
    }

    @Override
    public Set<String> getResourcePaths() {
        LinkedHashSet<String> trimmedPaths = new LinkedHashSet<String>();
        try {
            Set contextPaths = this.context.getResourcePaths(this.contextResourcePrefix);
            for (String contextPath : contextPaths) {
                if (!contextPath.startsWith(this.contextResourcePrefix)) continue;
                String trimPath = contextPath.substring(this.contextResourcePrefix.length());
                trimmedPaths.add(trimPath);
                LOGGER.debug("found resource: " + trimPath);
            }
            return trimmedPaths;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

