/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.pogo;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.pdk.Configuration;
import com.ibm.cognos.pdc.core.ehcache.pogo.DispatcherFinder;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.pogo.PDCDispatcher;
import com.ibm.cognos.pdc.core.ehcache.pogo.PDCDispatcherFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

public class DefaultDispatcherFinder
implements DispatcherFinder {
    private static final Logger LOGGER = LogKitFactory.getLogger(DefaultDispatcherFinder.class);
    private final PDCDispatcherFactory dispatcherFactory;

    public DefaultDispatcherFinder() {
        this(PDCDispatcherFactory.getInstance());
    }

    public DefaultDispatcherFinder(PDCDispatcherFactory dispatcherFactory) {
        this.dispatcherFactory = dispatcherFactory;
    }

    @Override
    public Set<PDCDispatcher> getDispatchers(Configuration config) {
        HashSet<PDCDispatcher> pdcDispatchers = new HashSet<PDCDispatcher>();
        DispatcherList dispList = (DispatcherList)config.getDispatcherList();
        this.addDispatchersFromList(pdcDispatchers, dispList);
        ICCLConfiguration cclConfig = config.getICCLConfiguration();
        this.addDispatchersFromCCLConfig(pdcDispatchers, cclConfig);
        return pdcDispatchers;
    }

    private void addDispatchersFromList(Set<PDCDispatcher> pdcDispatchers, DispatcherList dispList) {
        Iterator i = dispList.getAllDispatcherListElements();
        while (i.hasNext()) {
            DispatcherListElement dispListElem = (DispatcherListElement)i.next();
            LOGGER.debug("processing dispatcher: " + dispListElem.getName() + ", " + dispListElem.getJmxUrl());
            try {
                PDCDispatcher pdcDispatcher = this.dispatcherFactory.getPDCDispatcher(dispListElem);
                pdcDispatchers.add(pdcDispatcher);
                LOGGER.debug("adding dispatcher: " + pdcDispatcher);
            }
            catch (Exception e) {
                this.logError(dispListElem, e);
            }
        }
    }

    private void addDispatchersFromCCLConfig(Set<PDCDispatcher> pdcDispatchers, ICCLConfiguration cclConfig) {
        String cmConfigName = "contentManagers";
        try {
            Element contentManagersElem = cclConfig.getValueElement("contentManagers", false);
            if (contentManagersElem != null) {
                this.addConfiguredCMs(pdcDispatchers, contentManagersElem);
            }
        }
        catch (CCLConfigurationException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void addConfiguredCMs(Set<PDCDispatcher> pdcDispatchers, Element contentManagersElem) {
        String xpathItem = "./*[local-name()='item']";
        String cmService = "contentManagerService";
        List itemNodes = contentManagersElem.selectNodes("./*[local-name()='item']");
        for (Node cmItemNode : itemNodes) {
            String dispUri = this.getDispatcherURI(cmItemNode);
            try {
                PDCDispatcher pdcDispatcher = this.dispatcherFactory.getPDCDispatcher(dispUri, "contentManagerService");
                if (pdcDispatchers.contains(pdcDispatcher)) continue;
                pdcDispatchers.add(pdcDispatcher);
                LOGGER.debug("adding CM dispatcher: " + pdcDispatcher);
            }
            catch (Exception e) {
                this.logError(dispUri, e);
            }
        }
    }

    private String getDispatcherURI(Node node) {
        String cmUri = node.getStringValue().trim();
        if (cmUri.endsWith("/")) {
            cmUri = cmUri.substring(0, cmUri.length() - 1);
        }
        int lastPathStep = cmUri.lastIndexOf("/");
        String dispUri = cmUri.substring(0, lastPathStep);
        return dispUri;
    }

    private void logError(DispatcherListElement disp, Exception e) {
        String dispName = disp != null ? disp.getName() : null;
        this.logError(dispName, e);
    }

    private void logError(String dispName, Exception e) {
        LOGGER.error("Error processing dispatcher: " + dispName, (Throwable)e);
    }
}

