/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache.rmi;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.rmi.CAMFactoryDelegate;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIEndpoint;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log.Logger;

public class CAMFactoryRMISocketFactory
extends RMISocketFactory {
    private static final Logger LOGGER = LogKitFactory.getLogger(CAMFactoryRMISocketFactory.class);
    private static final CAMFactoryRMISocketFactory INSTANCE = new CAMFactoryRMISocketFactory();
    private boolean enableSSL = false;
    private CAMFactoryDelegate camFactory;
    private Set<RMIEndpoint> localSSLEndpoints;
    private volatile Set<RMIEndpoint> peerSSLEndpoints;

    public static CAMFactoryRMISocketFactory getInstance() {
        return INSTANCE;
    }

    protected CAMFactoryRMISocketFactory() {
        this(new CAMFactoryDelegate(new CAMFactory()));
    }

    protected CAMFactoryRMISocketFactory(CAMFactoryDelegate camFactory) {
        this.camFactory = camFactory;
        this.peerSSLEndpoints = Collections.synchronizedSet(new HashSet());
        this.localSSLEndpoints = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        boolean useSSL = this.useSSLForSocket(host, port);
        Socket socket = this.camFactory.createSocket(host, port, useSSL);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket;
        if (this.useSSLForServerSocket(port)) {
            serverSocket = this.camFactory.createMutualAuthServerSocket(port);
            int localPort = serverSocket.getLocalPort();
            LOGGER.info("Created mutual SSL server socket port " + localPort);
        } else {
            serverSocket = this.camFactory.createServerSocket(port, false);
        }
        return serverSocket;
    }

    private boolean useSSLForSocket(String host, int port) {
        boolean useSSL = this.enableSSL;
        RMIEndpoint endpoint = RMIEndpoint.getEndpointByName(host, port);
        useSSL = useSSL && this.useSSLForEndpoint(endpoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("createSocket(" + endpoint + ") useSSL=" + useSSL);
        }
        return useSSL;
    }

    private boolean useSSLForServerSocket(int port) {
        boolean useSSL = false;
        if (this.enableSSL) {
            RMIEndpoint endpoint = this.getLocalEndpoint(port);
            useSSL = this.useSSLForEndpoint(endpoint);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("useSSLForServerSocket(" + port + ")=" + useSSL);
        }
        return useSSL;
    }

    protected RMIEndpoint getLocalEndpoint(int port) {
        return RMIEndpoint.getLocalEndpoint(port);
    }

    private boolean useSSLForEndpoint(RMIEndpoint endpoint) {
        boolean useSSL;
        RMIEndpoint normalizedEndpoint = endpoint.isLocal() ? this.getLocalEndpoint(endpoint.getPort()) : endpoint;
        boolean bl = useSSL = this.localSSLEndpoints.contains(normalizedEndpoint) || this.peerSSLEndpoints.contains(endpoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("useSSLForEndpoint(" + endpoint + ")=" + useSSL + " [normalized: " + normalizedEndpoint + "]");
            this.dumpEndpoints("localSSLEndpoints", this.localSSLEndpoints);
            this.dumpEndpoints("peerSSLEndpoints", this.peerSSLEndpoints);
        }
        return useSSL;
    }

    public void initialize(boolean enableSSL) throws IOException {
        this.enableSSL = enableSSL;
        this.camFactory.initializeWithServiceID("PDC");
    }

    public void registerLocalPort(int port) {
        RMIEndpoint localEndpoint = this.getLocalEndpoint(port);
        this.localSSLEndpoints.add(localEndpoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered local endpoint: " + localEndpoint);
        }
    }

    public void clearPeerSSLEndpoints() {
        this.peerSSLEndpoints.clear();
        LOGGER.debug("Cleared peer endpoints");
    }

    private void dumpEndpoints(String label, Set<RMIEndpoint> endpoints) {
        LOGGER.debug("# " + label + " size=" + endpoints.size());
        for (RMIEndpoint endpoint : endpoints) {
            LOGGER.debug("## " + label + ": endpoint: " + endpoint);
        }
    }

    public Set<RMIEndpoint> getLocalSSLEndpoints() {
        return this.localSSLEndpoints;
    }

    public void registerPeerSSLEndpoints(RMIEndpoint ... endpoints) {
        this.registerPeerSSLEndpoints(Arrays.asList(endpoints));
    }

    public void registerPeerSSLEndpoints(Collection<RMIEndpoint> endpoints) {
        for (RMIEndpoint endpoint : endpoints) {
            LOGGER.debug("registerPeerSSLEndpoint(" + endpoint + ")");
            this.peerSSLEndpoints.add(endpoint);
        }
    }
}

