/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc;

import com.ibm.cognos.pdc.PDCGrid;
import com.ibm.cognos.pdc.core.Counter;
import com.ibm.cognos.pdc.core.ICounter;
import com.ibm.cognos.pdc.core.PDCGridBuilder;
import com.ibm.cognos.pdc.core.PDCGridBuilderFinder;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.diagnostics.PDCDiagnostics;
import java.util.HashMap;
import java.util.Map;

public class PDC {
    public static ICounter IN_PDC = new Counter("InPDC");
    private Map<String, PDCGrid> pdcGrids = new HashMap<String, PDCGrid>();
    private PDCGridBuilder gridBuilder;

    public PDC() {
        this(new PDCGridBuilderFinder().findBuilder());
    }

    public PDC(PDCGridBuilder builder) {
        this.gridBuilder = builder;
    }

    public PDCGrid getPDCGrid(String componentId) {
        PDCGrid grid = this.pdcGrids.get(componentId.toUpperCase());
        if (grid == null) {
            grid = this.buildGrid(componentId);
        }
        return grid;
    }

    private PDCGrid buildGrid(String componentId) {
        PDCGrid grid = this.gridBuilder.buildPDCGrid(componentId);
        this.pdcGrids.put(componentId.toUpperCase(), grid);
        PDCLogging.PDC_DEBUG.info("Built a " + grid.getClass().getName() + " for component ID: " + componentId);
        return grid;
    }

    static {
        PDCDiagnostics.getInstance().registerGlobalCounter(IN_PDC);
    }
}

