/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.CacheMap;
import com.ibm.cognos.pdc.PDC;
import com.ibm.cognos.pdc.core.ICounter;
import com.ibm.cognos.pdc.core.PDCClock;

public abstract class AbstractCountersCacheMap
implements CacheMap {
    protected static ICounter IN_PDC = PDC.IN_PDC;

    @Override
    public void clear() throws CacheException {
        long startTime = PDCClock.getCurrentTimeMillis();
        try {
            this.clearImpl();
        }
        finally {
            IN_PDC.incrementBy(PDCClock.getCurrentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) throws CacheException {
        long startTime = PDCClock.getCurrentTimeMillis();
        try {
            boolean bl = this.containsKeyImpl(key);
            return bl;
        }
        finally {
            IN_PDC.incrementBy(PDCClock.getCurrentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) throws CacheException {
        long startTime = PDCClock.getCurrentTimeMillis();
        try {
            Object object = this.getImpl(key);
            return object;
        }
        finally {
            IN_PDC.incrementBy(PDCClock.getCurrentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) throws CacheException {
        long startTime = PDCClock.getCurrentTimeMillis();
        try {
            Object object = this.putImpl(key, value);
            return object;
        }
        finally {
            IN_PDC.incrementBy(PDCClock.getCurrentTimeMillis() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) throws CacheException {
        long startTime = PDCClock.getCurrentTimeMillis();
        try {
            Object object = this.removeImpl(key);
            return object;
        }
        finally {
            IN_PDC.incrementBy(PDCClock.getCurrentTimeMillis() - startTime);
        }
    }

    @Override
    public abstract String getName();

    public abstract void clearImpl() throws CacheException;

    public abstract boolean containsKeyImpl(Object var1) throws CacheException;

    public abstract Object getImpl(Object var1) throws CacheException;

    public abstract Object putImpl(Object var1, Object var2) throws CacheException;

    public abstract Object removeImpl(Object var1) throws CacheException;
}

