/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.CacheMap;
import com.ibm.cognos.pdc.PDC;
import com.ibm.cognos.pdc.PDCGrid;
import com.ibm.cognos.pdc.Session;
import com.ibm.cognos.pdc.SessionContext;
import com.ibm.cognos.pdc.core.ICounter;
import com.ibm.cognos.pdc.core.PDCClock;
import java.util.List;

public abstract class AbstractCountersSession
implements Session {
    protected static ICounter IN_PDC = PDC.IN_PDC;

    @Override
    public void begin() throws CacheException {
        long startTime = PDCClock.getCurrentTimeMillis();
        try {
            this.beginImpl();
        }
        finally {
            IN_PDC.incrementBy(PDCClock.getCurrentTimeMillis() - startTime);
        }
    }

    @Override
    public void commit() throws CacheException {
        long startTime = PDCClock.getCurrentTimeMillis();
        try {
            this.commitImpl();
        }
        finally {
            IN_PDC.incrementBy(PDCClock.getCurrentTimeMillis() - startTime);
        }
    }

    @Override
    public void rollback() throws CacheException {
        long startTime = PDCClock.getCurrentTimeMillis();
        try {
            this.rollbackImpl();
        }
        finally {
            IN_PDC.incrementBy(PDCClock.getCurrentTimeMillis() - startTime);
        }
    }

    public abstract void beginImpl() throws CacheException;

    public abstract void commitImpl() throws CacheException;

    public abstract void rollbackImpl() throws CacheException;

    @Override
    public abstract List<String> getMapNames();

    @Override
    public abstract SessionContext getSessionContext();

    @Override
    public abstract CacheMap getMap(String var1) throws CacheException;

    @Override
    public abstract PDCGrid getPDCGrid();

    @Override
    public abstract boolean isTransactionActive();
}

