/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.CompoundKey;
import com.ibm.cognos.pdc.core.CMPDCTTLEvictorData;
import com.ibm.cognos.pdc.core.EvictionHandler;
import com.ibm.cognos.pdc.core.MapMaxSizeRetriever;
import com.ibm.cognos.pdc.core.MemoryUsageNotifier;
import com.ibm.cognos.pdc.core.PDCEvictionEventCallback;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.eviction.DaemonThreadFactory;
import com.ibm.cognos.pdc.core.eviction.EvictionEventCallback;
import com.ibm.cognos.pdc.core.eviction.Evictor;
import com.ibm.cognos.pdc.core.eviction.EvictorData;
import com.ibm.cognos.pdc.core.eviction.LogElement;
import com.ibm.cognos.pdc.core.eviction.LogSequence;
import com.ibm.cognos.pdc.core.eviction.TTLType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMPDCTTLEvictor
implements Runnable,
Evictor,
MemoryUsageNotifier.Listener {
    protected static MapMaxSizeRetriever maxSizes = new MapMaxSizeRetriever();
    public static final int DEFAULT_TIME_TO_LIVE_SECS = 600;
    public static final int DEFAULT_TTLEVICTIOR_SLEEP_TIME_SECS = 60;
    private static final float DEFAULT_PERCENTAGE_TO_EVICT = 0.2f;
    private String mapName;
    private EvictionEventCallback evictorCallback_;
    private EvictionHandler handler;
    private Queue<EvictorData> queue_;
    private ExecutorService executor_;
    private TTLType ttlType_ = null;
    private long ttlMillis_;
    private long sleepTimeMillis_;
    private float percentageToEvict_;
    private Long maxSize;
    private boolean initialized_;
    private boolean memThresholdCrossed_;

    public CMPDCTTLEvictor() {
        this(TTLType.LAST_ACCESS_TIME, 600, 60, 0.2f);
    }

    public CMPDCTTLEvictor(TTLType type, int ttl, int sleepTimeSecs) {
        this(type, ttl, sleepTimeSecs, 0.2f);
    }

    public CMPDCTTLEvictor(TTLType type, int ttl, int sleepTimeSecs, float percent) {
        this.ttlType_ = type;
        this.setTimeToLive(ttl);
        this.setSleepTimeSecs(sleepTimeSecs);
        this.memThresholdCrossed_ = false;
        this.percentageToEvict_ = percent;
    }

    @Override
    public TTLType getTTLType() {
        return this.ttlType_;
    }

    @Override
    public void setTTLType(TTLType type) {
        this.assertIsNotInitialized();
        this.ttlType_ = type;
    }

    @Override
    public int getTimeToLive() {
        return (int)(this.ttlMillis_ / 1000L);
    }

    @Override
    public void setTimeToLive(int ttl) {
        this.assertIsNotInitialized();
        this.ttlMillis_ = ttl * 1000;
    }

    public int getSleepTimeSecs() {
        return (int)(this.sleepTimeMillis_ / 1000L);
    }

    public void setSleepTimeSecs(int sleepTime) {
        this.assertIsNotInitialized();
        this.sleepTimeMillis_ = sleepTime * 1000;
    }

    public void setPercentageToEvictWhenMemoryIsLow(float percent) {
        this.assertIsNotInitialized();
        if ((double)percent <= 0.0 || (double)percent > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        this.percentageToEvict_ = percent;
    }

    public double getPercentageToEvictWhenMemoryIsLow() {
        return this.percentageToEvict_;
    }

    protected boolean isEntryExpired(long currentTime, long lastAccessTime) {
        return currentTime - lastAccessTime >= this.ttlMillis_;
    }

    private synchronized List<EvictorData> applyTimeBasedEvictionPolicy(long currentTime) {
        PDCLogging.PDC_DEBUG.fine("Applying Time based eviction policy for map '" + this.mapName + "'. Queue size(): " + this.queue_.size());
        boolean done = this.queue_.size() == 0;
        EvictorData data = null;
        ArrayList<EvictorData> evictorDataList = null;
        while (!done) {
            data = this.queue_.peek();
            long lastAccessTime = ((CMPDCTTLEvictorData)data).getLastAccessTime();
            PDCLogging.PDC_DEBUG.finest("LastAccessTime for entry " + data.getKey() + " : " + lastAccessTime);
            if (this.isEntryExpired(currentTime, lastAccessTime)) {
                PDCLogging.PDC_DEBUG.finest("Queue entry: " + data.getKey() + " will be evicted.");
                if (evictorDataList == null) {
                    evictorDataList = new ArrayList<EvictorData>();
                }
                evictorDataList.add(this.queue_.poll());
                done = this.queue_.size() == 0;
                continue;
            }
            done = true;
        }
        return evictorDataList;
    }

    private synchronized List<EvictorData> applyMemoryBasedEvictionPolicy() {
        PDCLogging.PDC_DEBUG.info("Applying Memory based eviction policy for map '" + this.mapName + "'. Queue size(): " + this.queue_.size());
        int sizeToRemove = Math.round((float)this.queue_.size() * this.percentageToEvict_);
        if (sizeToRemove == 0 && this.queue_.size() > 0) {
            sizeToRemove = 1;
        }
        PDCLogging.PDC_DEBUG.info("Evicting " + this.percentageToEvict_ * 100.0f + "% (" + sizeToRemove + " entries).");
        ArrayList<EvictorData> evictorDataList = new ArrayList<EvictorData>();
        for (int i = 0; i < sizeToRemove; ++i) {
            PDCLogging.PDC_DEBUG.finest("Queue entry: " + this.queue_.peek().getKey() + " will be evicted.");
            evictorDataList.add(this.queue_.poll());
        }
        return evictorDataList;
    }

    private synchronized List<EvictorData> applySizeBasedEvictionPolicy() {
        EvictorData toRemove;
        long currentSize = this.handler.getMemorySize();
        PDCLogging.PDC_DEBUG.info("Size threshold reached for map '" + this.mapName + "', currentSize=" + currentSize + "maxSize=" + this.getMaxSize());
        ArrayList<EvictorData> evictorDataList = new ArrayList<EvictorData>();
        for (long sizeToRemove = currentSize - this.getMaxSize(); sizeToRemove > 0L && !this.queue_.isEmpty(); sizeToRemove -= toRemove.getSize()) {
            toRemove = this.queue_.poll();
            evictorDataList.add(toRemove);
            PDCLogging.PDC_DEBUG.finest("Queue entry: " + toRemove.getKey() + " will be evicted.");
        }
        return evictorDataList;
    }

    private boolean sizeLimitReached() {
        return this.handler.getMemorySize() > this.getMaxSize();
    }

    @Override
    public void run() {
        PDCLogging.PDC_INFO.info("Eviction thread started for map '" + this.mapName + "'");
        try {
            while (!Thread.interrupted()) {
                boolean memoryLow = this.waitForEvictionPeriodAndCheckMemThresholdCrossing();
                this.processEvictions(memoryLow, System.currentTimeMillis());
            }
            if (this.executor_.isShutdown()) {
                PDCLogging.PDC_INFO.info("Exiting Evictor thread via while() test for map: '" + this.mapName + "'.");
            } else {
                PDCLogging.PDC_INFO.info("Restarting Evictor Thread for map: '" + this.mapName + "' because it was interrupted.");
                this.executor_.execute(this);
            }
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException && this.executor_.isShutdown()) {
                PDCLogging.PDC_INFO.info("Exiting Evictor thread for map: '" + this.mapName + "' via InterruptedException.");
            }
            Logger.getLogger("com.ibm.cognos.pdc.Info").log(Level.WARNING, "Restarting Evictor thread for map: '" + this.mapName + "' due to exception: ", e);
            this.executor_.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForEvictionPeriodAndCheckMemThresholdCrossing() throws InterruptedException {
        PDCLogging.PDC_DEBUG.finest("Evictor Thread for Map '" + this.mapName + "' waiting for " + this.getSleepTimeSecs() + " seconds for memory threshold crossing event... ");
        boolean memoryLow = false;
        CMPDCTTLEvictor cMPDCTTLEvictor = this;
        synchronized (cMPDCTTLEvictor) {
            this.wait(this.sleepTimeMillis_);
            if (this.memThresholdCrossed_) {
                PDCLogging.PDC_DEBUG.finest("Evictor Thread for Map '" + this.mapName + "' woken up by memory threshold crossing event!");
                this.memThresholdCrossed_ = false;
                memoryLow = true;
            } else {
                PDCLogging.PDC_DEBUG.finest("Evictor Thread for Map '" + this.mapName + "' woken up due to timer expiry.");
            }
        }
        return memoryLow;
    }

    protected void processEvictions(boolean memoryLow, long currentTime) {
        List<EvictorData> evictorDataList = memoryLow ? this.applyMemoryBasedEvictionPolicy() : (this.sizeLimitReached() ? this.applySizeBasedEvictionPolicy() : this.applyTimeBasedEvictionPolicy(currentTime));
        if (evictorDataList != null && evictorDataList.size() > 0) {
            try {
                PDCLogging.PDC_DEBUG.fine("Calling evictorCallback to evict entries for map: '" + this.mapName + "'.");
                this.evictorCallback_.evictMapEntries(evictorDataList);
            }
            catch (CacheException ex) {
                PDCLogging.PDC_DEBUG.fine("CMPDC TTLEvictor failed to evict map entries for map: '" + this.mapName + "'.");
                ex.printStackTrace();
            }
        }
    }

    private void processForGetUpdate(Object key, long lastAccessTime, long size) {
        EvictorData data = this.evictorCallback_.getEvictorData(key);
        if (data != EvictorData.KEY_NOT_FOUND) {
            CMPDCTTLEvictorData dataForUpdate = (CMPDCTTLEvictorData)data;
            dataForUpdate.setLastAccessTime(lastAccessTime);
            dataForUpdate.setSize(size);
            this.queue_.remove(dataForUpdate);
            this.queue_.offer(dataForUpdate);
        }
    }

    private void processForInsert(Object key, long lastAccessTime, long size) {
        CMPDCTTLEvictorData dataForInsert = new CMPDCTTLEvictorData(key, lastAccessTime, size);
        this.evictorCallback_.setEvictorData(key, dataForInsert);
        this.queue_.offer(dataForInsert);
    }

    @Override
    public synchronized void apply(LogSequence sequence) {
        Iterator<LogElement> iter = sequence.getAllChanges();
        while (iter.hasNext()) {
            LogElement elem = iter.next();
            Object key = elem.getKey();
            Object pk = key instanceof CompoundKey ? ((CompoundKey)key).getPrimaryKey() : key;
            LogElement.Type type = elem.getType();
            long lastAccessTime = elem.getLastAccessTime();
            long size = elem.getSize();
            switch (type) {
                case INSERT: {
                    if (this.evictorCallback_.containsKey(pk)) {
                        this.processForGetUpdate(pk, lastAccessTime, size);
                        break;
                    }
                    this.processForInsert(pk, lastAccessTime, size);
                    break;
                }
                case UPDATE: 
                case GET: {
                    this.processForGetUpdate(pk, lastAccessTime, size);
                    break;
                }
                case REMOVE: {
                    if (key instanceof CompoundKey) {
                        if (!this.evictorCallback_.containsKey(pk)) break;
                        this.processForGetUpdate(pk, lastAccessTime, size);
                        break;
                    }
                    EvictorData dataForRemove = this.evictorCallback_.getEvictorData(pk);
                    if (dataForRemove == EvictorData.KEY_NOT_FOUND) break;
                    this.evictorCallback_.removeEvictorData(pk, dataForRemove);
                    this.queue_.remove(dataForRemove);
                }
            }
        }
    }

    @Override
    public void destroy() {
        this.executor_.shutdownNow();
    }

    @Override
    public synchronized void initialize(String gridId, String mapName, EvictionHandler handler) {
        if (this.initialized_) {
            return;
        }
        this.mapName = mapName;
        this.handler = handler;
        if (this.maxSize == null) {
            this.maxSize = new Long(maxSizes.getMapMaxSize(gridId, mapName));
        }
        this.evictorCallback_ = new PDCEvictionEventCallback(handler);
        this.queue_ = new LinkedList<EvictorData>();
        DaemonThreadFactory threadFactory = new DaemonThreadFactory();
        this.executor_ = Executors.newSingleThreadExecutor(threadFactory);
        this.startExecutor();
        this.initialized_ = true;
    }

    protected void startExecutor() {
        this.executor_.execute(this);
    }

    private void assertIsNotInitialized() {
        if (this.initialized_) {
            throw new IllegalStateException("This method cannot be called after the evictor has been initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memoryUsageLow(long usedMemory, long maxMemory) {
        PDCLogging.PDC_DEBUG.fine("Memory usage low is detected in the evictor for map: '" + this.mapName + "'.");
        double percentageUsed = (double)usedMemory / (double)maxMemory;
        PDCLogging.PDC_DEBUG.fine("percentageUsed = " + percentageUsed);
        CMPDCTTLEvictor cMPDCTTLEvictor = this;
        synchronized (cMPDCTTLEvictor) {
            this.memThresholdCrossed_ = true;
            this.notifyAll();
        }
    }

    @Override
    public long getMaxSize() {
        return this.maxSize == null ? 0L : this.maxSize;
    }

    @Override
    public void setMaxSize(long size) {
        this.maxSize = new Long(size);
    }

    @Override
    public synchronized int getQueueSize() {
        return this.queue_.size();
    }

    @Override
    public synchronized EvictorData peekQueue() {
        return this.queue_.peek();
    }
}

