/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.core.ICounter;
import com.ibm.cognos.pdc.core.PDCClock;
import java.util.concurrent.atomic.AtomicLong;

public class Counter
implements ICounter {
    private long lastReset;
    private AtomicLong value;
    private String name;

    public Counter(String name) {
        this.name = name;
        this.value = new AtomicLong(0L);
        this.lastReset = PDCClock.getCurrentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    @Override
    public void incrementBy(long delta) {
        this.value.addAndGet(delta);
    }

    @Override
    public void increment() {
        this.value.incrementAndGet();
    }

    @Override
    public void decrementBy(int delta) {
        this.value.addAndGet(-delta);
    }

    @Override
    public void decrement() {
        this.value.decrementAndGet();
    }

    @Override
    public void reset() {
        this.value.set(0L);
        this.lastReset = PDCClock.getCurrentTimeMillis();
    }

    @Override
    public long getTimeSinceLastReset() {
        return PDCClock.getCurrentTimeMillis() - this.lastReset;
    }
}

