/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.core.PDCLogging;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class MapMaxSizeRetriever {
    protected static String RESOURCE_NAME = "pdcmapsizes.properties";
    public static final long FALLBACK_DEFAULT_SIZE = 15000000L;
    public static final String DEFAULT_PROP_NAME = "com.ibm.cognos.pdc.defaultMaxMapSize";
    private Properties mapSizes;
    private Long defaultMaxSize;

    public long getMapMaxSize(String gridId, String mapId) {
        if (this.mapSizes == null) {
            this.initializeSizes();
        }
        return this.internalGetSize(gridId.toUpperCase() + "." + mapId.toUpperCase());
    }

    private long internalGetSize(String id) {
        long result;
        PDCLogging.PDC_TRACE.finer("Getting max size for map: " + id);
        String size = this.mapSizes.getProperty(id);
        if (size != null) {
            try {
                result = Long.parseLong(size);
            }
            catch (NumberFormatException e) {
                PDCLogging.PDC_ERROR.info("Unable to parse max size for map '" + id + "', input string: '" + size + "', falling back on default.");
                result = this.fallback();
            }
        } else {
            PDCLogging.PDC_TRACE.fine("No max size for map '" + id + "' falling back on default.");
            result = this.fallback();
        }
        PDCLogging.PDC_TRACE.finer("Returning max size " + result + " for map '" + id + "'.");
        return result;
    }

    private long fallback() {
        if (this.defaultMaxSize != null) {
            return this.defaultMaxSize;
        }
        return 15000000L;
    }

    private void initializeSizes() {
        String defaultSize;
        this.mapSizes = this.initializeSizesWithLoader(Thread.currentThread().getContextClassLoader());
        if (this.mapSizes == null) {
            this.mapSizes = this.initializeSizesWithLoader(this.getClass().getClassLoader());
        }
        if (this.mapSizes == null) {
            this.mapSizes = new Properties();
        }
        if ((defaultSize = (String)this.mapSizes.remove(DEFAULT_PROP_NAME)) != null) {
            try {
                this.defaultMaxSize = new Long(Long.parseLong(defaultSize));
            }
            catch (NumberFormatException e) {
                PDCLogging.PDC_ERROR.log(Level.INFO, "Failed to parse default max map size string '" + defaultSize + "'", e);
            }
        } else {
            PDCLogging.PDC_ERROR.info("Failed to load default max map size. Will be using hard coded default: 15000000");
        }
        this.capitalizeKeys(this.mapSizes);
    }

    private void capitalizeKeys(Properties map) {
        Properties newMap = new Properties();
        for (Object key : map.keySet()) {
            String keyString = key.toString();
            String value = map.getProperty(keyString);
            newMap.put(keyString.toUpperCase(), value);
        }
        map.clear();
        map.putAll((Map<?, ?>)newMap);
    }

    private Properties initializeSizesWithLoader(ClassLoader loader) {
        InputStream stream = this.getInputStreamFrom(loader, RESOURCE_NAME);
        if (stream == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(stream);
            return props;
        }
        catch (IOException e) {
            PDCLogging.PDC_ERROR.log(Level.INFO, "Failed to load max map sizes.", e);
            return null;
        }
    }

    protected InputStream getInputStreamFrom(ClassLoader loader, String resourceName) {
        return loader.getResourceAsStream(resourceName);
    }
}

