/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.core.CMPDCTTLEvictorData;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.eviction.EvictorData;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryUsageNotifier {
    public static final double DEFAULT_THRESHOLD_PERCENTAGE = 0.8;
    private final List<Listener> listeners_ = new ArrayList<Listener>();
    private double thresholdPercentage_;
    private static final MemoryPoolMXBean tenuredGenPool_ = MemoryUsageNotifier.findTenuredGenPool();
    private static NotificationEmitter emitter_ = MemoryUsageNotifier.loadNotificationEmitter();

    public MemoryUsageNotifier() {
        this(0.8);
    }

    public MemoryUsageNotifier(double percentage) {
        this.setThresholdPercentage(percentage);
        emitter_.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object handback) {
                if (n.getType().equals("java.management.memory.threshold.exceeded")) {
                    PDCLogging.PDC_DEBUG.fine("Memory threshold crossed count: " + tenuredGenPool_.getUsageThresholdCount());
                    for (Listener listener : MemoryUsageNotifier.this.listeners_) {
                        if (listener.getQueueSize() <= 0) continue;
                        EvictorData data = listener.peekQueue();
                        long lastAccessTime = ((CMPDCTTLEvictorData)data).getLastAccessTime();
                        PDCLogging.PDC_DEBUG.finest("LastAccessTime for entry " + data.getKey() + " : " + lastAccessTime);
                        if (System.currentTimeMillis() - lastAccessTime < 600000L) continue;
                        long maxMemory = tenuredGenPool_.getUsage().getMax();
                        long usedMemory = tenuredGenPool_.getUsage().getUsed();
                        listener.memoryUsageLow(usedMemory, maxMemory);
                    }
                }
            }
        }, null, null);
    }

    private static NotificationEmitter loadNotificationEmitter() {
        PDCLogging.PDC_DEBUG.fine("Loading NotificationEmitter");
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        return (NotificationEmitter)((Object)mbean);
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            PDCLogging.PDC_DEBUG.fine("Found Tenured Generation Pool. Name: " + pool.getName() + "; Usage: " + pool.getUsage());
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured generation pool.");
    }

    public boolean addListener(Listener listener) {
        return this.listeners_.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners_.remove(listener);
    }

    public void setThresholdPercentage(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Threshold Percentage not in range");
        }
        this.thresholdPercentage_ = percentage;
        long maxMemory = tenuredGenPool_.getUsage().getMax();
        long threshold = (long)((double)maxMemory * percentage);
        tenuredGenPool_.setUsageThreshold(threshold);
    }

    public double getThresholdPercentage() {
        return this.thresholdPercentage_;
    }

    public static void setNotificationEmitter_TEST(NotificationEmitter emitter) {
        PDCLogging.PDC_DEBUG.fine("Mock Emitter is Injected.");
        emitter_ = emitter;
    }

    public static void resetNotificationEmitter_TEST() {
        PDCLogging.PDC_DEBUG.fine("Mock Emitter is Ejected.");
        emitter_ = MemoryUsageNotifier.loadNotificationEmitter();
    }

    public static interface Listener {
        public void memoryUsageLow(long var1, long var3);

        public int getQueueSize();

        public EvictorData peekQueue();
    }
}

