/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.core.EvictionHandler;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.eviction.EvictionEventCallback;
import com.ibm.cognos.pdc.core.eviction.EvictorData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PDCEvictionEventCallback
implements EvictionEventCallback {
    private EvictionHandler evictionHandler;
    private Map<Object, EvictorData> evictorDataMap = new ConcurrentHashMap<Object, EvictorData>();

    public PDCEvictionEventCallback(EvictionHandler handler) {
        this.evictionHandler = handler;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.evictorDataMap.containsKey(key);
    }

    @Override
    public void setEvictorData(Object key, EvictorData data) {
        this.evictorDataMap.put(key, data);
    }

    @Override
    public EvictorData getEvictorData(Object key) {
        if (!this.evictorDataMap.containsKey(key)) {
            return EvictorData.KEY_NOT_FOUND;
        }
        return this.evictorDataMap.get(key);
    }

    @Override
    public void removeEvictorData(Object key, EvictorData data) {
        if (this.evictorDataMap.containsKey(key) && data == this.evictorDataMap.get(key)) {
            this.evictorDataMap.remove(key);
        }
    }

    @Override
    public void evictMapEntries(List<EvictorData> evictorDataList) throws CacheException {
        Iterator<EvictorData> iter = evictorDataList.iterator();
        EvictorData dataToEvict = null;
        Object key = null;
        while (iter.hasNext()) {
            dataToEvict = iter.next();
            key = dataToEvict.getKey();
            if (!this.evictorDataMap.containsKey(key) || !this.evictionHandler.containsEntry(key) || dataToEvict != this.evictorDataMap.get(key)) continue;
            PDCLogging.PDC_DEBUG.finest("Removing map entry with key: " + key);
            this.evictionHandler.removeEntry(key);
            this.evictorDataMap.remove(key);
        }
    }
}

