/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.core.PDCGridBuilder;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.local.LocalPDCGridBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;

public class PDCGridBuilderFinder {
    protected static String RESOURCE_NAME = "META-INF/services/" + PDCGridBuilder.class.getName();

    public PDCGridBuilder findBuilder() {
        PDCGridBuilder builder = this.findBuilderWithLoader(Thread.currentThread().getContextClassLoader());
        if (null != builder) {
            return builder;
        }
        builder = this.findBuilderWithLoader(this.getClass().getClassLoader());
        if (null != builder) {
            return builder;
        }
        PDCLogging.PDC_DEBUG.log(Level.WARNING, "The class loader could not find the META-INF/services/" + PDCGridBuilder.class.getName() + " file to determine which PDCGridBuilder implementation to use. The LocalPDCGridBuilder implementation will be used.");
        return new LocalPDCGridBuilder();
    }

    private PDCGridBuilder findBuilderWithLoader(ClassLoader loader) {
        InputStream stream = loader.getResourceAsStream(RESOURCE_NAME);
        if (null == stream) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = reader.readLine();
            while (null != line) {
                PDCGridBuilder builder;
                line = line.trim();
                if (0 != (line = this.removeComments(line)).length() && null != (builder = this.loadPDCGridBuilder(line))) {
                    return builder;
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            PDCLogging.PDC_ERROR.log(Level.WARNING, "An error occurred while reading the META-INF/services/" + PDCGridBuilder.class.getName() + " file.", ex);
        }
        return null;
    }

    private String removeComments(String line) {
        int pos = line.indexOf("#");
        if (-1 != pos) {
            line = line.substring(0, pos).trim();
        }
        return line;
    }

    public PDCGridBuilder loadPDCGridBuilder(String classname) {
        try {
            Class<?> klass = Class.forName(classname);
            return (PDCGridBuilder)klass.newInstance();
        }
        catch (ClassNotFoundException ex) {
            PDCLogging.PDC_ERROR.log(Level.SEVERE, "The PDCGridBuilder implementation class '" + classname + "' could not be located.");
        }
        catch (IllegalAccessException e) {
            PDCLogging.PDC_ERROR.log(Level.SEVERE, "The PDCGridBuilder implementation class '" + classname + "' has a no-argument constructor that's not public.");
        }
        catch (InstantiationException e) {
            PDCLogging.PDC_ERROR.log(Level.SEVERE, "The PDCGridBuilder implementation class '" + classname + "' is not instantiable (interface, abstract class) or it does not have a public no-argument constructor.");
        }
        return null;
    }
}

