/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class PDCLogging {
    private static final int MEGABYTE = 0x100000;
    private static Handler fileHandler;
    private static Filter filter;
    public static Logger PDC_ERROR;
    public static Logger PDC_DEBUG;
    public static Logger PDC_TRACE;
    public static Logger PDC_INFO;

    public static void initialize() {
        PDCLogging.searchForLoggingFilter();
        PDC_ERROR = PDCLogging.initializeLogger("Error", "pdc.log", Level.WARNING);
        PDC_DEBUG = PDCLogging.initializeLogger("Debug", "pdc.log", Level.WARNING);
        PDC_TRACE = PDCLogging.initializeLogger("Trace", "pdc.log", Level.WARNING);
        PDC_INFO = PDCLogging.initializeLogger("Info", "pdc.log", Level.INFO);
        PDC_INFO.log(Level.INFO, "PDC started.");
    }

    private static void searchForLoggingFilter() {
        try {
            Class<?> klass = Class.forName("com.ibm.cognos.pdc.core.PDCLoggingFilter");
            Method method = klass.getMethod("provideFilter", new Class[0]);
            filter = (Filter)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Logger initializeLogger(String name, String filename, Level defaultLevel) {
        String loggerName = "com.ibm.cognos.pdc." + name;
        try {
            Logger logger = Logger.getLogger(loggerName);
            PDCLogging.configureFilter(logger);
            PDCLogging.configureHandlers(logger);
            logger.setLevel(PDCLogging.getConfigurableValue(loggerName + ".level", defaultLevel));
            return logger;
        }
        catch (Throwable th) {
            PDCLogging.logThrowable("An error occurred while configuring the PDC logger " + loggerName + ". The anonymous logger will be used in its place.", th);
            return Logger.getAnonymousLogger();
        }
    }

    private static void configureHandlers(Logger logger) {
        Handler handler = PDCLogging.getFileHandler();
        if (null != handler) {
            logger.addHandler(handler);
        }
        logger.setUseParentHandlers(null == handler);
    }

    private static synchronized Handler getFileHandler() {
        if (null == fileHandler) {
            PDCLogging.createFileHandler();
        }
        return fileHandler;
    }

    private static void createFileHandler() {
        FileHandler handler = null;
        String filename = System.getProperty("com.ibm.cognos.pdc.LogFile", null);
        if (filename == null) {
            filename = CCLConfigurationFactory.getInstance().resolveEffectivePath("../logs/pdc-%g.log");
        }
        try {
            handler = new FileHandler(filename, PDCLogging.getConfigurableValue("com.ibm.cognos.pdc.LogFileSize", 0xA00000), PDCLogging.getConfigurableValue("com.ibm.cognos.pdc.LogFileCount", 10), true);
            handler.setFormatter(new SimpleFormatter());
        }
        catch (IOException ex) {
            PDCLogging.logThrowable("Failed to create log file " + filename.replaceFirst("\\%g", "?"), ex);
        }
        fileHandler = handler;
    }

    private static int getConfigurableValue(String property, int defaultValue) {
        int value = defaultValue;
        String propertyValue = System.getProperty(property);
        if (null != propertyValue) {
            try {
                value = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException ex) {
                PDCLogging.logThrowable("The configuration value for the PDC property " + property + " is intended to be an integer value but could not be parsed as such.", ex);
            }
        }
        return value;
    }

    private static void logThrowable(String message, Throwable throwable) {
        Logger logger = Logger.getLogger("com.ibm.cognos.pdc.Error");
        logger.log(Level.SEVERE, message, throwable);
    }

    private static Level getConfigurableValue(String property, Level defaultValue) {
        Level level = defaultValue;
        String propertyValue = System.getProperty(property);
        if (null != propertyValue) {
            try {
                level = Level.parse(propertyValue);
            }
            catch (IllegalArgumentException ex) {
                PDCLogging.logThrowable("The configuration value for the PDC property " + property + " is intended to be a known java.util.logging.Level name or an integer value.", ex);
            }
        }
        return level;
    }

    private static void configureFilter(Logger logger) {
        if (null != filter) {
            logger.setFilter(filter);
        }
    }

    public static <T extends Exception> T logAndReturnException(Logger logger, Level level, T exception) {
        logger.log(level, exception.getLocalizedMessage(), exception);
        return exception;
    }

    public static void main(String[] args) {
        String[] values = new String[]{"ALL", "all", "All", "aLl"};
        for (int i = 0; i < values.length; ++i) {
            Level l = Level.parse(values[i]);
            System.out.println(l.getName());
        }
    }

    static {
        PDCLogging.initialize();
    }
}

