/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.CacheMap;
import com.ibm.cognos.pdc.PDCGrid;
import com.ibm.cognos.pdc.SessionContext;
import com.ibm.cognos.pdc.core.AbstractCountersSession;
import com.ibm.cognos.pdc.core.NoActiveTransactionException;
import com.ibm.cognos.pdc.core.PDCBackend;
import com.ibm.cognos.pdc.core.PDCBackendException;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.TransactionAlreadyActiveException;
import com.ibm.cognos.pdc.core.TransactionCache;
import com.ibm.cognos.pdc.core.TransactionException;
import java.util.List;
import java.util.logging.Level;

public class PDCSession
extends AbstractCountersSession {
    private PDCGrid owner;
    private TransactionCache cache;
    private PDCBackend backend;
    private boolean inTransaction;
    private SessionContext sessionContext;

    public PDCSession(PDCGrid owner, SessionContext sessionContext, TransactionCache cache, PDCBackend server) {
        this.owner = owner;
        this.sessionContext = sessionContext;
        this.cache = cache;
        this.backend = server;
    }

    public PDCSession(PDCGrid owner, SessionContext sessionContext, PDCBackend reader) {
        this(owner, sessionContext, new TransactionCache(reader), reader);
    }

    @Override
    public void beginImpl() throws CacheException {
        if (this.isTransactionActive()) {
            throw PDCLogging.logAndReturnException(PDCLogging.PDC_ERROR, Level.WARNING, new TransactionAlreadyActiveException("Transaction is already active."));
        }
        this.inTransaction = true;
        this.cache.resetMaps();
    }

    @Override
    public void commitImpl() throws CacheException {
        if (!this.isTransactionActive()) {
            throw PDCLogging.logAndReturnException(PDCLogging.PDC_ERROR, Level.WARNING, new NoActiveTransactionException("commit must be called in a transaction"));
        }
        this.inTransaction = false;
        if (this.cache.hasMapChanges()) {
            try {
                this.backend.commit(this, this.cache.getMapChanges());
            }
            catch (PDCBackendException e) {
                throw PDCLogging.logAndReturnException(PDCLogging.PDC_ERROR, Level.INFO, new TransactionException("Commit failed", e));
            }
        }
    }

    @Override
    public CacheMap getMap(String mapName) throws CacheException {
        if (mapName == null) {
            throw PDCLogging.logAndReturnException(PDCLogging.PDC_ERROR, Level.WARNING, new NullPointerException("The mapName argument cannot be null."));
        }
        return this.cache.getTransactionCacheMap(mapName, this);
    }

    @Override
    public boolean isTransactionActive() {
        return this.inTransaction;
    }

    @Override
    public void rollbackImpl() throws CacheException {
        if (!this.isTransactionActive()) {
            throw PDCLogging.logAndReturnException(PDCLogging.PDC_ERROR, Level.WARNING, new NoActiveTransactionException("rollback must be called in a transaction"));
        }
        this.inTransaction = false;
        this.cache.resetMaps();
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public PDCGrid getPDCGrid() {
        return this.owner;
    }

    @Override
    public List<String> getMapNames() {
        return this.getPDCGrid().getMapNames();
    }
}

