/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.Session;
import com.ibm.cognos.pdc.core.MapChange;
import com.ibm.cognos.pdc.core.PDCBackend;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.TransactionCacheMap;
import com.ibm.cognos.pdc.core.TransactionCacheMapBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class TransactionCache {
    protected static TransactionCacheMapBuilder MAP_BUILDER = new TransactionCacheMapBuilder();
    private Map<String, TransactionCacheMap> cachedMaps;
    private PDCBackend backend;

    public TransactionCache(PDCBackend backend) {
        this.backend = backend;
        this.cachedMaps = new HashMap<String, TransactionCacheMap>();
    }

    public void resetMaps() {
        for (TransactionCacheMap map : this.cachedMaps.values()) {
            map.reset();
        }
        PDCLogging.PDC_DEBUG.log(Level.INFO, "All TransactionCacheMap instances reset in TransactionCache.");
    }

    public boolean hasMapChanges() {
        for (TransactionCacheMap map : this.cachedMaps.values()) {
            if (!map.hasWriteOperations()) continue;
            return true;
        }
        return false;
    }

    public List<MapChange> getMapChanges() {
        ArrayList<MapChange> mapChanges = new ArrayList<MapChange>();
        for (TransactionCacheMap map : this.cachedMaps.values()) {
            if (!map.hasWriteOperations()) continue;
            mapChanges.add(map);
        }
        return mapChanges;
    }

    public TransactionCacheMap getTransactionCacheMap(String mapName, Session owner) {
        TransactionCacheMap cachedMap = this.cachedMaps.get(mapName.toUpperCase());
        if (cachedMap == null) {
            cachedMap = MAP_BUILDER.createTransactionCacheMap(mapName, owner, this.backend);
            this.cachedMaps.put(mapName.toUpperCase(), cachedMap);
            PDCLogging.PDC_DEBUG.log(Level.INFO, "New TransactionCacheMap for name " + mapName + " added to TransactionCache.");
        }
        return cachedMap;
    }
}

