/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.Session;
import com.ibm.cognos.pdc.core.AbstractCountersCacheMap;
import com.ibm.cognos.pdc.core.FirstReadValue;
import com.ibm.cognos.pdc.core.MapChange;
import com.ibm.cognos.pdc.core.PDCBackend;
import com.ibm.cognos.pdc.core.PDCBackendException;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.PutOperation;
import com.ibm.cognos.pdc.core.RemoveOperation;
import com.ibm.cognos.pdc.core.TransactionAlreadyActiveException;
import com.ibm.cognos.pdc.core.WriteOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class TransactionCacheMap
extends AbstractCountersCacheMap
implements MapChange {
    private Map<Object, FirstReadValue> firstReadValues;
    private Map<Object, WriteOperation> lastWriteOperations;
    private PDCBackend backend;
    private Session parent;
    private String mapId;

    public TransactionCacheMap(String mapId, Session parent, PDCBackend backend) {
        this.mapId = mapId;
        this.backend = backend;
        this.parent = parent;
        this.firstReadValues = new HashMap<Object, FirstReadValue>();
        this.lastWriteOperations = new HashMap<Object, WriteOperation>();
    }

    public void reset() {
        this.firstReadValues.clear();
        this.lastWriteOperations.clear();
        PDCLogging.PDC_DEBUG.fine("Transaction Cache Map reset.");
    }

    @Override
    public boolean hasWriteOperations() {
        return !this.lastWriteOperations.isEmpty();
    }

    @Override
    public List<WriteOperation> getWriteOperations() {
        return new ArrayList<WriteOperation>(this.lastWriteOperations.values());
    }

    @Override
    public void clearImpl() throws CacheException, TransactionAlreadyActiveException {
        if (this.parent.isTransactionActive()) {
            throw new TransactionAlreadyActiveException("Cannot call clear() in a transaction.");
        }
        try {
            this.backend.clear(this.parent, this.getName());
        }
        catch (PDCBackendException e) {
            throw new CacheException("Error occured while executing clear on server", e);
        }
    }

    @Override
    public boolean containsKeyImpl(Object key) throws CacheException {
        this.verifyKeyNotNull(key);
        return this.getValue(key.toString(), false) != null;
    }

    @Override
    public Object getImpl(Object key) throws CacheException {
        this.verifyKeyNotNull(key);
        return this.getValue(key, true);
    }

    private Object executeGet(Object key) throws CacheException {
        try {
            return this.backend.get(this.parent, this.getName(), key);
        }
        catch (PDCBackendException e) {
            throw new CacheException("Error occured while executing get on server", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putImpl(Object key, Object value) throws CacheException {
        this.verifyKeyNotNull(key);
        this.verifyValueNotNull(value);
        boolean inTransaction = this.parent.isTransactionActive();
        if (!inTransaction) {
            this.parent.begin();
        }
        try {
            Object result = this.getValue(key, true);
            this.setPutAsLastOperationOnKey(key, value, this.firstReadValues.get(key).getValue());
            Object object = result;
            return object;
        }
        finally {
            if (!inTransaction) {
                this.parent.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeImpl(Object key) throws CacheException {
        this.verifyKeyNotNull(key);
        boolean inTransaction = this.parent.isTransactionActive();
        if (!inTransaction) {
            this.parent.begin();
        }
        try {
            Object result = this.getValue(key, true);
            this.setRemoveAsLastOperationOnKey(key, this.firstReadValues.get(key).getValue());
            Object object = result;
            return object;
        }
        finally {
            if (!inTransaction) {
                this.parent.commit();
            }
        }
    }

    private void verifyKeyNotNull(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("The key argument cannot be null");
        }
    }

    private void verifyValueNotNull(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("The value argument cannot be null");
        }
    }

    private Object getValue(Object key, boolean storeAsFirstReadValueIfFirstRead) throws CacheException {
        Object result;
        WriteOperation lastOperationOnKey = this.lastWriteOperations.get(key);
        if (lastOperationOnKey != null) {
            result = lastOperationOnKey.getNewValue();
            PDCLogging.PDC_TRACE.log(Level.FINEST, "The requested value was modified in this transaction, returning the modified version: " + result);
        } else {
            FirstReadValue box = this.firstReadValues.get(key);
            if (box != null) {
                result = box.getValue();
                PDCLogging.PDC_TRACE.log(Level.FINEST, "Retrieving the previously read value from the server: " + result);
            } else {
                result = this.executeGet(key);
                PDCLogging.PDC_TRACE.log(Level.FINEST, "Read the value from the server: " + result);
                if (storeAsFirstReadValueIfFirstRead) {
                    this.firstReadValues.put(key, new FirstReadValue(result));
                    PDCLogging.PDC_TRACE.log(Level.FINEST, "Caching the value read from the server: " + result);
                }
            }
        }
        return result;
    }

    private void setPutAsLastOperationOnKey(Object key, Object firstReadValue, Object value) {
        this.lastWriteOperations.put(key, new PutOperation(key, firstReadValue, value));
    }

    private void setRemoveAsLastOperationOnKey(Object key, Object firstReadValue) {
        this.lastWriteOperations.put(key, new RemoveOperation(key, firstReadValue));
    }

    @Override
    public String getName() {
        return this.mapId;
    }

    @Override
    public String getMapId() {
        return this.getName();
    }

    @Override
    public Iterator<Object> getKeys() throws CacheException {
        throw new UnsupportedOperationException();
    }
}

