/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core;

import com.ibm.cognos.pdc.core.OperableCacheMap;
import com.ibm.cognos.pdc.core.OptimisticLockingException;
import com.ibm.cognos.pdc.local.BackendMap;

public abstract class WriteOperation {
    private final Object firstReadValue;
    private final Object key;
    private final Object newValue;

    public WriteOperation(Object key, Object newValue, Object firstReadValue) {
        if (key == null) {
            throw new IllegalArgumentException("The key argument cannot be null");
        }
        this.key = key;
        this.firstReadValue = firstReadValue;
        this.newValue = newValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getFirstReadValue() {
        return this.firstReadValue;
    }

    public abstract void execute(OperableCacheMap var1);

    public abstract String getOperationName();

    public abstract boolean includeValueInCommit();

    public void checkForOptimisticLockingCollision(BackendMap map) throws OptimisticLockingException {
        Object commitedValue = map.get(this.key);
        if (!this.compare(commitedValue, this.firstReadValue)) {
            throw new OptimisticLockingException(null, map.getName(), this.key, commitedValue, this.firstReadValue);
        }
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (null != o && this.getClass() == o.getClass()) {
            WriteOperation other = (WriteOperation)o;
            return this.key.equals(other.getKey()) && this.compare(this.newValue, other.newValue) && this.compare(this.firstReadValue, other.firstReadValue);
        }
        return false;
    }

    protected boolean compare(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }
}

