/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.diagnostics;

import com.ibm.cognos.pdc.core.ICounter;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.diagnostics.AgeStatistics;
import com.ibm.cognos.pdc.core.diagnostics.DiagnosticGrid;
import com.ibm.cognos.pdc.core.diagnostics.DiagnosticMap;
import com.ibm.cognos.pdc.core.diagnostics.SizeStatistics;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDCDiagnostics {
    protected static PDCDiagnostics INSTANCE = new PDCDiagnostics();
    private Map<String, ICounter> globalCounters;
    private Map<String, DiagnosticGrid> grids = new HashMap<String, DiagnosticGrid>();

    public static PDCDiagnostics getInstance() {
        return INSTANCE;
    }

    public PDCDiagnostics() {
        this.globalCounters = new HashMap<String, ICounter>();
    }

    public ICounter getGlobalCounter(String counterId) {
        return this.globalCounters.get(counterId);
    }

    public DiagnosticGrid getDiagnosticGrid(String gridId) {
        return this.grids.get(gridId.toUpperCase());
    }

    public void registerGlobalCounter(ICounter counter) {
        String counterName = counter.getName();
        if (this.globalCounters.containsKey(counterName)) {
            PDCLogging.PDC_ERROR.warning("Global counter with name " + counterName + " has already been registered, overriding.");
        }
        this.globalCounters.put(counterName, counter);
    }

    public void registerMapCounters(String parentGridId, String mapId, List<ICounter> counters) {
        DiagnosticMap map = this.getDiagnosticMapCreateIfNecessary(parentGridId, mapId);
        for (ICounter counter : counters) {
            if (map.getCounter(counter.getName()) != null) {
                PDCLogging.PDC_ERROR.warning("Grid: " + parentGridId + ", Map: " + mapId + ", a counter with name " + counter.getName() + " has already been registered, overriding.");
            }
            map.addCounter(counter);
        }
    }

    protected synchronized DiagnosticGrid getDiagnosticGridCreateIfNecessary(String gridId) {
        DiagnosticGrid grid = this.grids.get(gridId.toUpperCase());
        if (grid == null) {
            grid = new DiagnosticGrid(gridId);
            this.grids.put(gridId.toUpperCase(), grid);
        }
        return grid;
    }

    protected synchronized DiagnosticMap getDiagnosticMapCreateIfNecessary(String parentGridId, String mapId) {
        DiagnosticGrid owner = this.getDiagnosticGridCreateIfNecessary(parentGridId);
        DiagnosticMap map = owner.getMap(mapId);
        if (map == null) {
            map = new DiagnosticMap(mapId);
            owner.addMap(map);
        }
        return map;
    }

    public void registerMapAgeStatistics(String parentGridId, String mapId, AgeStatistics ageStatistics) {
        DiagnosticMap map = this.getDiagnosticMapCreateIfNecessary(parentGridId, mapId);
        map.setAgeStatistics(ageStatistics);
    }

    public void registerMapSizeStatistics(String parentGridId, String mapId, SizeStatistics sizeStatistics) {
        DiagnosticMap map = this.getDiagnosticMapCreateIfNecessary(parentGridId, mapId);
        map.setSizeStatistics(sizeStatistics);
    }

    public Collection<ICounter> getGlobalCounters() {
        return this.globalCounters.values();
    }
}

