/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.diagnostics;

import com.ibm.cognos.pdc.CompoundKey;
import com.ibm.cognos.pdc.core.PDCLogging;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;

public class SizeStatistics {
    private Map<Object, SizeInfo> key2SizeInfo = new HashMap<Object, SizeInfo>();
    private SortedSet<SizeInfo> sizeInfoByValueSize = new TreeSet<SizeInfo>(new SizeInfoComparator());

    public synchronized void putSizeInfo(Object key, long keySize, long valueSize) {
        PDCLogging.PDC_TRACE.finer("Putting key '" + key.toString() + "' in SizeStatistics, key size=" + keySize + ", value size=" + valueSize);
        SizeInfo info = new SizeInfo(keySize, valueSize);
        SizeInfo oldInfo = this.key2SizeInfo.put(key, info);
        if (oldInfo != null) {
            this.sizeInfoByValueSize.remove(oldInfo);
        }
        this.sizeInfoByValueSize.add(info);
    }

    public synchronized void putSizeInfo(CompoundKey compoundKey, long keySize, long valueSize) {
        this.putSizeInfo(compoundKey.getPrimaryKey(), keySize, valueSize);
    }

    public synchronized void removeKey(Object key) {
        PDCLogging.PDC_TRACE.finer("Removing key '" + key.toString() + "' from SizeStatistics");
        SizeInfo oldInfo = this.key2SizeInfo.remove(key);
        if (oldInfo != null) {
            this.sizeInfoByValueSize.remove(oldInfo);
        }
    }

    public synchronized void removeKey(CompoundKey compoundKey) {
        this.removeKey(compoundKey.getPrimaryKey());
    }

    public synchronized SizeInfo getSizeInfo(Object key) {
        return this.key2SizeInfo.get(key);
    }

    public synchronized SizeInfo getSizeInfo(CompoundKey compoundKey) {
        return this.getSizeInfo(compoundKey.getPrimaryKey());
    }

    public synchronized long getLargestValueSize() {
        if (!this.sizeInfoByValueSize.isEmpty()) {
            return this.sizeInfoByValueSize.last().getValueSize();
        }
        return 0L;
    }

    public synchronized long getSmallestValueSize() {
        if (!this.sizeInfoByValueSize.isEmpty()) {
            return this.sizeInfoByValueSize.first().getValueSize();
        }
        return 0L;
    }

    public synchronized long getTotalSize() {
        long total = 0L;
        for (SizeInfo info : this.key2SizeInfo.values()) {
            total += info.getKeySize() + info.getValueSize();
        }
        return total;
    }

    public synchronized long getTotalKeySize() {
        long total = 0L;
        for (SizeInfo info : this.key2SizeInfo.values()) {
            total += info.getKeySize();
        }
        return total;
    }

    public synchronized long getTotalValueSize() {
        long total = 0L;
        for (SizeInfo info : this.key2SizeInfo.values()) {
            total += info.getValueSize();
        }
        return total;
    }

    public synchronized double getAverageKeySize() {
        double size = this.key2SizeInfo.size();
        if (size == 0.0) {
            return 0.0;
        }
        return (double)this.getTotalKeySize() / size;
    }

    public synchronized double getAverageValueSize() {
        double size = this.key2SizeInfo.size();
        if (size == 0.0) {
            return 0.0;
        }
        return (double)this.getTotalValueSize() / size;
    }

    public static class SizeInfoComparator
    implements Comparator<SizeInfo> {
        @Override
        public int compare(SizeInfo o1, SizeInfo o2) {
            int result;
            if (o1.equals(o2)) {
                result = 0;
            } else {
                result = (int)(o1.valueSize - o2.valueSize);
                if (result == 0) {
                    result = o1.uuid.compareTo(o2.uuid);
                }
            }
            return result;
        }
    }

    public static class SizeInfo {
        private final UUID uuid;
        private final long keySize;
        private final long valueSize;

        protected SizeInfo(long keySize, long valueSize) {
            this(UUID.randomUUID(), keySize, valueSize);
        }

        protected SizeInfo(UUID uuid, long keySize, long valueSize) {
            this.uuid = uuid;
            this.keySize = keySize;
            this.valueSize = valueSize;
        }

        public long getKeySize() {
            return this.keySize;
        }

        public long getValueSize() {
            return this.valueSize;
        }
    }
}

