/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.lru;

import com.ibm.cognos.pdc.core.lru.UUIDKey;

public class LRUEntry
implements Comparable<LRUEntry> {
    private final UUIDKey key;
    private long timeMillis;

    protected LRUEntry(UUIDKey key, long ageMillis) {
        this.key = key;
        this.timeMillis = ageMillis;
    }

    public UUIDKey getKey() {
        return this.key;
    }

    public long getTime() {
        return this.timeMillis;
    }

    protected void setTime(long millis) {
        this.timeMillis = millis;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o instanceof LRUEntry) {
            LRUEntry other = (LRUEntry)o;
            isEqual = other.key.equals(this.key);
        }
        return isEqual;
    }

    @Override
    public int compareTo(LRUEntry other) {
        long timeDelta;
        int comparison = this.key.compareTo(other.key);
        if (comparison != 0 && (timeDelta = other.timeMillis - this.timeMillis) != 0L) {
            comparison = timeDelta > 0L ? -1 : 1;
        }
        return comparison;
    }

    public String toString() {
        return "LRUEntry(" + this.key + "," + this.timeMillis + ")";
    }
}

