/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.lru;

import com.ibm.cognos.pdc.core.lru.LRUEntry;
import com.ibm.cognos.pdc.core.lru.UUIDKey;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class LRUSet
implements Iterable<LRUEntry> {
    private final ConcurrentHashMap<UUIDKey, LRUEntry> map = new ConcurrentHashMap();
    private final ConcurrentSkipListSet<LRUEntry> set = new ConcurrentSkipListSet();

    public void add(UUIDKey key, long time) {
        LRUEntry entry = new LRUEntry(key, time);
        this.map.put(key, entry);
        this.set.add(entry);
    }

    public void touch(UUIDKey key, long time) {
        LRUEntry entry = this.map.get(key);
        if (entry != null) {
            this.touchEntry(entry, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touchEntry(LRUEntry entry, long time) {
        LRUEntry lRUEntry = entry;
        synchronized (lRUEntry) {
            this.set.remove(entry);
            entry.setTime(time);
            this.set.add(entry);
        }
    }

    public long getTime(UUIDKey key) {
        long time = 0L;
        LRUEntry entry = this.map.get(key);
        if (entry != null) {
            time = entry.getTime();
        }
        return time;
    }

    public void remove(UUIDKey key) {
        LRUEntry entry = this.map.get(key);
        if (entry != null) {
            this.set.remove(entry);
            this.map.remove(key);
        }
    }

    public void clear() {
        this.set.clear();
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public LRUEntry last() {
        return this.set.last();
    }

    public LRUEntry first() {
        return this.set.first();
    }

    @Override
    public Iterator<LRUEntry> iterator() {
        return this.set.iterator();
    }
}

