/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.lru;

import com.ibm.cognos.pdc.CompoundKey;
import com.ibm.cognos.pdc.core.PDCClock;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.diagnostics.AgeStatistics;
import com.ibm.cognos.pdc.core.lru.LRUEntry;
import com.ibm.cognos.pdc.core.lru.LRUSet;
import com.ibm.cognos.pdc.core.lru.UUIDKey;
import java.util.concurrent.ConcurrentHashMap;

public class LRUSetAgeStatistics
implements AgeStatistics {
    protected ConcurrentHashMap<Object, UUIDKey> key2uuid = new ConcurrentHashMap();
    protected LRUSet creationTime = new LRUSet();
    protected LRUSet modificationTime = new LRUSet();
    protected LRUSet lastAccessTime = new LRUSet();

    @Override
    public void registerNewKey(Object key) {
        UUIDKey existingUuid;
        UUIDKey uuidKey = this.key2uuid.get(key);
        if (uuidKey == null && (existingUuid = this.key2uuid.putIfAbsent(key, uuidKey = new UUIDKey(key))) == null) {
            PDCLogging.PDC_TRACE.finer("Registering new key '" + key + "' in AgeStatistics");
            long time = PDCClock.getCurrentTimeMillis();
            this.creationTime.add(uuidKey, time);
            this.modificationTime.add(uuidKey, time);
            this.lastAccessTime.add(uuidKey, time);
        }
    }

    @Override
    public void registerNewKey(CompoundKey compoundKey) {
        this.registerNewKey(compoundKey.getPrimaryKey());
    }

    @Override
    public void touchKey(Object key) {
        UUIDKey id = this.key2uuid.get(key);
        if (id != null) {
            PDCLogging.PDC_TRACE.finest("AgeStatistics: touching key '" + key + "'");
            this.lastAccessTime.touch(id, PDCClock.getCurrentTimeMillis());
        }
    }

    @Override
    public void touchKey(CompoundKey compoundKey) {
        this.touchKey(compoundKey.getPrimaryKey());
    }

    @Override
    public void modifyKey(Object key) {
        UUIDKey id = this.key2uuid.get(key);
        if (id != null) {
            PDCLogging.PDC_TRACE.finest("AgeStatistics: modifying key '" + key + "'");
            long time = PDCClock.getCurrentTimeMillis();
            this.lastAccessTime.touch(id, time);
            this.modificationTime.touch(id, time);
        }
    }

    @Override
    public void modifyKey(CompoundKey compoundKey) {
        this.modifyKey(compoundKey.getPrimaryKey());
    }

    @Override
    public void clear() {
        PDCLogging.PDC_TRACE.finer("Clearing AgeStatistics");
        this.creationTime.clear();
        this.modificationTime.clear();
        this.lastAccessTime.clear();
    }

    @Override
    public void removeKey(Object key) {
        UUIDKey id = this.key2uuid.get(key);
        if (id != null) {
            PDCLogging.PDC_TRACE.finer("Removing key '" + key + "' from AgeStatistics");
            this.key2uuid.remove(key);
            this.creationTime.remove(id);
            this.modificationTime.remove(id);
            this.lastAccessTime.remove(id);
        }
    }

    @Override
    public void removeKey(CompoundKey compoundKey) {
        this.removeKey(compoundKey.getPrimaryKey());
    }

    @Override
    public Object getYoungestCreated() {
        return this.getYoungest(this.creationTime);
    }

    @Override
    public Object getOldestCreated() {
        return this.getOldest(this.creationTime);
    }

    @Override
    public Object getYoungestModified() {
        return this.getYoungest(this.modificationTime);
    }

    @Override
    public Object getOldestModified() {
        return this.getOldest(this.modificationTime);
    }

    @Override
    public Object getYoungestAccessed() {
        return this.getYoungest(this.lastAccessTime);
    }

    @Override
    public Object getOldestAccessed() {
        return this.getOldest(this.lastAccessTime);
    }

    @Override
    public Double getAverageCreationTime() {
        return this.getAverage(this.creationTime);
    }

    @Override
    public Double getAverageModificationTime() {
        return this.getAverage(this.modificationTime);
    }

    @Override
    public Double getAverageLastAccessTime() {
        return this.getAverage(this.lastAccessTime);
    }

    private Object getYoungest(LRUSet stats) {
        Object result = null;
        LRUEntry entry = this.getYoungestEntry(stats);
        if (entry != null) {
            result = entry.getKey().getValue();
        }
        return result;
    }

    private LRUEntry getYoungestEntry(LRUSet stats) {
        LRUEntry entry = null;
        if (!stats.isEmpty()) {
            entry = stats.last();
        }
        return entry;
    }

    private Object getOldest(LRUSet stats) {
        Object result = null;
        LRUEntry entry = this.getOldestEntry(stats);
        if (entry != null) {
            result = entry.getKey().getValue();
        }
        return result;
    }

    private LRUEntry getOldestEntry(LRUSet stats) {
        LRUEntry entry = null;
        if (!stats.isEmpty()) {
            entry = stats.first();
        }
        return entry;
    }

    private Double getAverage(LRUSet set) {
        double size = 0.0;
        double total = 0.0;
        for (LRUEntry entry : set) {
            total += (double)entry.getTime();
            size += 1.0;
        }
        Double result = null;
        if (size > 0.0) {
            result = new Double(total / size);
        }
        return result;
    }

    @Override
    public long getCreationTime(Object key) {
        return this.getTime(this.creationTime, key);
    }

    @Override
    public long getModificationTime(Object key) {
        return this.getTime(this.modificationTime, key);
    }

    @Override
    public long getLastAccessTime(Object key) {
        return this.getTime(this.lastAccessTime, key);
    }

    private long getTime(LRUSet set, Object key) {
        long time = 0L;
        UUIDKey uuidKey = this.key2uuid.get(key);
        if (uuidKey != null) {
            time = set.getTime(uuidKey);
        }
        return time;
    }

    @Override
    public AgeStatistics.AgeStats getOldestByCreationTime() {
        LRUEntry entry = this.getOldestEntry(this.creationTime);
        return new AgeStatsProxy(entry);
    }

    @Override
    public AgeStatistics.AgeStats getYoungestByCreationTime() {
        LRUEntry entry = this.getYoungestEntry(this.creationTime);
        return new AgeStatsProxy(entry);
    }

    @Override
    public AgeStatistics.AgeStats getYoungestByModificationTime() {
        LRUEntry entry = this.getYoungestEntry(this.modificationTime);
        return new AgeStatsProxy(entry);
    }

    @Override
    public AgeStatistics.AgeStats getOldestByModificationTime() {
        LRUEntry entry = this.getOldestEntry(this.modificationTime);
        return new AgeStatsProxy(entry);
    }

    @Override
    public AgeStatistics.AgeStats getYoungestByLastAccessTime() {
        LRUEntry entry = this.getYoungestEntry(this.lastAccessTime);
        return new AgeStatsProxy(entry);
    }

    @Override
    public AgeStatistics.AgeStats getOldestByLastAccessTime() {
        LRUEntry entry = this.getOldestEntry(this.lastAccessTime);
        return new AgeStatsProxy(entry);
    }

    public class AgeStatsProxy
    extends AgeStatistics.AgeStats {
        private UUIDKey key;

        protected AgeStatsProxy(LRUEntry entry) {
            super(entry.getKey(), entry.getTime());
            this.key = entry.getKey();
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public long getCreationTime() {
            return LRUSetAgeStatistics.this.creationTime.getTime(this.key);
        }

        @Override
        public long getModificationTime() {
            return LRUSetAgeStatistics.this.modificationTime.getTime(this.key);
        }

        @Override
        public long getLastAccessTime() {
            return LRUSetAgeStatistics.this.lastAccessTime.getTime(this.key);
        }
    }
}

