/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.local;

import com.ibm.cognos.pdc.BackingMap;
import com.ibm.cognos.pdc.Session;
import com.ibm.cognos.pdc.core.MapChange;
import com.ibm.cognos.pdc.core.OptimisticLockingException;
import com.ibm.cognos.pdc.core.PDCBackend;
import com.ibm.cognos.pdc.core.PDCBackendException;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.WriteOperation;
import com.ibm.cognos.pdc.core.eviction.EvictionTriggers;
import com.ibm.cognos.pdc.local.BackendFactory;
import com.ibm.cognos.pdc.local.BackendGridVisitor;
import com.ibm.cognos.pdc.local.BackendMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BackendGrid
implements PDCBackend {
    private Map<String, BackendMap> maps;
    private String gridId;
    private BackendFactory factory;
    private boolean initialized;

    public BackendGrid(String gridId, BackendFactory factory) {
        this(gridId, new HashMap<String, BackendMap>(), factory);
    }

    public BackendGrid(String gridId, Map<String, BackendMap> cache, BackendFactory factory) {
        this.gridId = gridId;
        this.maps = cache;
        this.factory = factory;
    }

    @Override
    public List<String> getMapNames() {
        ArrayList<String> result = new ArrayList<String>(this.maps.size());
        for (BackendMap map : this.maps.values()) {
            result.add(map.getMapName());
        }
        return result;
    }

    public List<BackingMap> getBackingMaps() {
        return new ArrayList<BackingMap>(this.maps.values());
    }

    public synchronized BackendMap getBackendMap(String mapId) {
        BackendMap result = this.maps.get(mapId.toUpperCase());
        if (result == null) {
            result = this.factory.createBackendMap(this, mapId);
            result.setEvictionTriggers(EnumSet.of(EvictionTriggers.EVICTIONTRIGGER_MEMORY_USAGE_THRESHOLD));
            result.initialize();
            this.maps.put(mapId.toUpperCase(), result);
        }
        return result;
    }

    @Override
    public synchronized void clear(Session session, String mapId) throws PDCBackendException {
        this.clear(mapId);
    }

    public synchronized void clear(String mapId) throws PDCBackendException {
        BackendMap map = this.getBackendMap(mapId);
        map.clear();
    }

    @Override
    public synchronized void commit(Session session, List<MapChange> mapChanges) throws PDCBackendException {
        this.commit(mapChanges);
    }

    public synchronized void commit(List<MapChange> mapChanges) throws OptimisticLockingException {
        this.verifyNoOptimisticLockingCollisions(mapChanges);
        this.executeOperations(mapChanges);
    }

    private void executeOperations(List<MapChange> mapChanges) {
        for (MapChange change : mapChanges) {
            BackendMap map = this.getBackendMap(change.getMapId());
            List<WriteOperation> operations = change.getWriteOperations();
            for (WriteOperation operation : operations) {
                operation.execute(map);
            }
        }
    }

    private void verifyNoOptimisticLockingCollisions(List<MapChange> mapChanges) throws OptimisticLockingException {
        for (MapChange change : mapChanges) {
            BackendMap map = this.getBackendMap(change.getMapId());
            List<WriteOperation> operations = change.getWriteOperations();
            for (WriteOperation operation : operations) {
                operation.checkForOptimisticLockingCollision(map);
            }
        }
    }

    @Override
    public synchronized Object get(Session session, String mapId, Object key) throws PDCBackendException {
        return this.get(mapId, key);
    }

    public synchronized Object get(String mapId, Object key) throws PDCBackendException {
        BackendMap map = this.getBackendMap(mapId);
        return map.get(key);
    }

    public synchronized void acceptVisitor(BackendGridVisitor visitor) {
        visitor.visitGrid(this);
        Set<String> mapsToVisit = visitor.getMapsToVisitForGrid(this.getId());
        if (mapsToVisit == null || mapsToVisit.isEmpty()) {
            for (BackendMap map : this.maps.values()) {
                map.accept(visitor);
            }
        } else {
            for (String mapId : mapsToVisit) {
                BackendMap map = this.getBackendMap(mapId);
                if (map == null) continue;
                map.accept(visitor);
            }
        }
        visitor.leaveGrid(this);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void initialize(List<BackingMap> initMaps) {
        this.maps.clear();
        for (BackingMap map : initMaps) {
            this.maps.put(map.getMapName().toUpperCase(), this.backingMapToBackendMap(map));
        }
        this.initialize();
    }

    private BackendMap backingMapToBackendMap(BackingMap backing) {
        BackendMap result = this.factory.createBackendMap(this, backing.getMapName());
        result.setEvictor(backing.getEvictor());
        result.setEvictionTriggers(backing.getEvictionTriggers());
        return result;
    }

    synchronized void initialize() {
        PDCLogging.PDC_INFO.info("Initializing grid '" + this.gridId + "'");
        for (BackendMap map : this.maps.values()) {
            map.initialize();
        }
        this.initialized = true;
    }

    void destroy() {
        for (BackendMap map : this.maps.values()) {
            map.destroy();
        }
    }

    public String getId() {
        return this.gridId;
    }
}

