/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.local;

import com.ibm.cognos.pdc.BackingMap;
import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.CompoundKey;
import com.ibm.cognos.pdc.core.CMPDCLogElement;
import com.ibm.cognos.pdc.core.CMPDCLogSequence;
import com.ibm.cognos.pdc.core.CMPDCTTLEvictor;
import com.ibm.cognos.pdc.core.Counter;
import com.ibm.cognos.pdc.core.EvictionHandler;
import com.ibm.cognos.pdc.core.ICounter;
import com.ibm.cognos.pdc.core.MemoryUsageNotifier;
import com.ibm.cognos.pdc.core.OperableCacheMap;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.diagnostics.AgeStatistics;
import com.ibm.cognos.pdc.core.diagnostics.SizeStatistics;
import com.ibm.cognos.pdc.core.eviction.EvictionTriggers;
import com.ibm.cognos.pdc.core.eviction.Evictor;
import com.ibm.cognos.pdc.core.eviction.LogElement;
import com.ibm.cognos.pdc.core.eviction.LogSequence;
import com.ibm.cognos.pdc.core.lru.LRUSetAgeStatistics;
import com.ibm.cognos.pdc.local.BackendGridVisitor;
import com.ibm.cognos.pdc.local.SizedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BackendMap
implements OperableCacheMap,
BackingMap,
EvictionHandler {
    protected ICounter hitsCounter;
    protected ICounter missesCounter;
    protected ICounter evictionCounter;
    protected ICounter requestCounter;
    protected ICounter sizeCounter;
    private AgeStatistics ageStatistics;
    protected SizeStatistics sizeStatistics;
    private final String mapId;
    private Map<Object, Object> data;
    private boolean initialized;
    private Evictor evictor;
    private EnumSet<EvictionTriggers> triggers = EnumSet.noneOf(EvictionTriggers.class);
    private double thresholdPercentage = 0.8;
    private MemoryUsageNotifier notifier = null;
    private String parentGridId;

    public BackendMap(String parentGridId, String mapId) {
        this(parentGridId, mapId, new ConcurrentHashMap<Object, Object>());
    }

    public BackendMap(String parentGridId, String mapId, Map<Object, Object> data) {
        this(parentGridId, mapId, data, new LRUSetAgeStatistics());
    }

    public BackendMap(String parentGridId, String mapId, Map<Object, Object> data, AgeStatistics stats) {
        this.parentGridId = parentGridId;
        this.mapId = mapId;
        this.data = data;
        this.ageStatistics = stats;
        this.sizeStatistics = new SizeStatistics();
        this.hitsCounter = new Counter("hits");
        this.missesCounter = new Counter("misses");
        this.evictionCounter = new Counter("evictions");
        this.requestCounter = new Counter("requests");
        this.sizeCounter = new Counter("size"){

            @Override
            public long getValue() {
                return BackendMap.this.data.size();
            }
        };
    }

    @Override
    public String getMapName() {
        return this.mapId;
    }

    public List<ICounter> getCounters() {
        return Arrays.asList(this.hitsCounter, this.missesCounter, this.evictionCounter, this.requestCounter, this.sizeCounter);
    }

    public AgeStatistics getAgeStatistics() {
        return this.ageStatistics;
    }

    public SizeStatistics getSizeStatistics() {
        return this.sizeStatistics;
    }

    @Override
    public Object get(Object key) {
        this.requestCounter.increment();
        if (key instanceof CompoundKey) {
            return this.getMappedValue((CompoundKey)key);
        }
        Object value = this.data.get(key);
        if (value != null) {
            this.ageStatistics.touchKey(key);
            this.hitsCounter.increment();
            this.updateEvictor(key, LogElement.Type.GET);
        } else {
            this.missesCounter.increment();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMappedValue(CompoundKey compoundKey) {
        SizedMap secondLevelMap = this.getSecondLevelMap(compoundKey, false);
        if (secondLevelMap == null) {
            return null;
        }
        Object result = null;
        SizedMap sizedMap = secondLevelMap;
        synchronized (sizedMap) {
            result = secondLevelMap.get(compoundKey.getSecondaryKey());
            if (result != null) {
                this.ageStatistics.touchKey(compoundKey);
                this.hitsCounter.increment();
                this.updateEvictor(compoundKey, LogElement.Type.GET);
            } else {
                this.missesCounter.increment();
            }
        }
        return result;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.put(key, value, 0L, 0L);
    }

    @Override
    public Object put(Object key, Object value, long keySize, long valueSize) {
        LogElement.Type type;
        this.requestCounter.increment();
        if (key instanceof CompoundKey) {
            return this.putMappedValue((CompoundKey)key, value, keySize, valueSize);
        }
        Object oldValue = this.data.put(key, value);
        if (oldValue == null) {
            this.ageStatistics.registerNewKey(key);
            type = LogElement.Type.INSERT;
        } else {
            this.ageStatistics.modifyKey(key);
            type = LogElement.Type.UPDATE;
        }
        this.updateEvictorForPut(key, type, keySize + valueSize);
        if (keySize != 0L || valueSize != 0L) {
            this.sizeStatistics.putSizeInfo(key, keySize, valueSize);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object putMappedValue(CompoundKey compoundKey, Object value, long keySize, long valueSize) {
        SizedMap secondLevelMap = this.getSecondLevelMap(compoundKey, true);
        Object oldValue = null;
        SizedMap sizedMap = secondLevelMap;
        synchronized (sizedMap) {
            boolean mapIsNew = secondLevelMap.isEmpty();
            oldValue = secondLevelMap.put(compoundKey.getSecondaryKey(), value, valueSize);
            LogElement.Type type = oldValue == null ? LogElement.Type.INSERT : LogElement.Type.UPDATE;
            if (mapIsNew) {
                this.ageStatistics.registerNewKey(compoundKey);
            } else {
                this.ageStatistics.modifyKey(compoundKey);
            }
            if (keySize != 0L || valueSize != 0L) {
                this.sizeStatistics.putSizeInfo(compoundKey.getPrimaryKey(), keySize, secondLevelMap.getMemorySize());
            }
            this.updateEvictor(compoundKey, type);
        }
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        this.requestCounter.increment();
        if (key instanceof CompoundKey) {
            return this.removeMappedValue((CompoundKey)key);
        }
        Object oldValue = this.data.remove(key);
        if (oldValue != null) {
            this.ageStatistics.removeKey(key);
            this.sizeStatistics.removeKey(key);
            this.updateEvictor(key, LogElement.Type.REMOVE);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeMappedValue(CompoundKey compoundKey) {
        SizedMap secondLevelMap = this.getSecondLevelMap(compoundKey, false);
        if (secondLevelMap == null) {
            return null;
        }
        Object oldValue = null;
        SizedMap sizedMap = secondLevelMap;
        synchronized (sizedMap) {
            oldValue = secondLevelMap.remove(compoundKey.getSecondaryKey());
            if (oldValue != null) {
                if (secondLevelMap.isEmpty()) {
                    this.ageStatistics.removeKey(compoundKey);
                    this.sizeStatistics.removeKey(compoundKey);
                } else {
                    this.ageStatistics.modifyKey(compoundKey);
                    SizeStatistics.SizeInfo info = this.sizeStatistics.getSizeInfo(compoundKey);
                    if (info != null) {
                        this.sizeStatistics.putSizeInfo(compoundKey, info.getKeySize(), secondLevelMap.getMemorySize());
                    }
                }
                this.updateEvictor(compoundKey, LogElement.Type.REMOVE);
            }
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.requestCounter.increment();
        if (!this.data.isEmpty()) {
            HashSet<Object> keys = new HashSet<Object>(this.data.keySet());
            this.data.clear();
            this.ageStatistics.clear();
            this.updateEvictor(keys, LogElement.Type.REMOVE);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.requestCounter.increment();
        if (key instanceof CompoundKey) {
            return this.containsMapping((CompoundKey)key);
        }
        return this.data.containsKey(key);
    }

    private boolean containsMapping(CompoundKey key) {
        SizedMap secondLevelMap = this.getSecondLevelMap(key, false);
        if (secondLevelMap == null) {
            return false;
        }
        return secondLevelMap.containsKey(key.getSecondaryKey());
    }

    private synchronized SizedMap getSecondLevelMap(CompoundKey key, boolean createIfAbsent) {
        Object secondLevel = this.data.get(key.getPrimaryKey());
        if (createIfAbsent && secondLevel == null) {
            secondLevel = new SizedMap();
            this.data.put(key.getPrimaryKey(), secondLevel);
        } else if (secondLevel != null && !(secondLevel instanceof SizedMap)) {
            throw new IllegalStateException("Key \"" + key.getPrimaryKey() + "\" does not yield a nested map.");
        }
        return (SizedMap)secondLevel;
    }

    public void accept(BackendGridVisitor visitor) {
        visitor.visitMap(this);
        List<Object> interestedKeys = visitor.getKeysToVisit();
        if (interestedKeys == null) {
            this.visitAllEntries(visitor);
        } else {
            this.visitEntriesForKeys(visitor, interestedKeys);
        }
        visitor.leaveMap(this);
    }

    private void visitEntriesForKeys(BackendGridVisitor visitor, List<Object> interestedKeys) {
        for (Object key : interestedKeys) {
            Object value = this.data.get(key);
            if (value == null) continue;
            visitor.visitMapEntry(key, value);
        }
    }

    private void visitAllEntries(BackendGridVisitor visitor) {
        for (Map.Entry<Object, Object> entry : this.data.entrySet()) {
            visitor.visitMapEntry(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getName() {
        return this.mapId;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized() {
        this.initialized = true;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        PDCLogging.PDC_INFO.info("initialize() called on BackendMap '" + this.getMapName() + "'");
        if (this.evictor == null) {
            this.evictor = new CMPDCTTLEvictor();
        }
        if (this.triggers.contains((Object)EvictionTriggers.EVICTIONTRIGGER_MEMORY_USAGE_THRESHOLD)) {
            PDCLogging.PDC_INFO.info("Memory Usage Notifier created and Threshold set to: " + this.thresholdPercentage);
            this.notifier = new MemoryUsageNotifier(this.thresholdPercentage);
            this.notifier.addListener((CMPDCTTLEvictor)this.evictor);
        }
        this.evictor.initialize(this.parentGridId, this.getMapName(), this);
        this.initialized = true;
    }

    private void assertNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("This method cannot be called after the map has been initialized.");
        }
    }

    private void updateEvictor(Object key, LogElement.Type type) {
        HashSet<Object> keySet = new HashSet<Object>();
        keySet.add(key);
        this.updateEvictor(keySet, type);
    }

    private void updateEvictorForPut(Object key, LogElement.Type type, long totalSize) {
        List<LogElement> elements = Arrays.asList(new CMPDCLogElement(type, key, System.currentTimeMillis(), totalSize));
        CMPDCLogSequence sequence = new CMPDCLogSequence(elements, this.getName());
        this.apply(sequence);
    }

    private void updateEvictor(Set<Object> keySet, LogElement.Type type) {
        ArrayList<LogElement> elements = new ArrayList<LogElement>();
        for (Object key : keySet) {
            CMPDCLogElement element = new CMPDCLogElement(type, key, System.currentTimeMillis());
            elements.add(element);
        }
        CMPDCLogSequence sequence = new CMPDCLogSequence(elements, this.getName());
        this.apply(sequence);
    }

    protected void apply(LogSequence sequence) {
        if (!this.isInitialized()) {
            return;
        }
        this.evictor.apply(sequence);
    }

    @Override
    public Evictor getEvictor() {
        return this.evictor;
    }

    @Override
    public void setEvictor(Evictor e) throws IllegalStateException {
        this.assertNotInitialized();
        this.evictor = e;
    }

    void setMemoryUsageThresholdPercentage(double percentage) {
        this.thresholdPercentage = percentage;
    }

    @Override
    public EnumSet<EvictionTriggers> getEvictionTriggers() {
        return this.triggers;
    }

    @Override
    public void setEvictionTriggers(EnumSet<EvictionTriggers> triggers) throws IllegalStateException {
        this.assertNotInitialized();
        this.triggers = triggers;
    }

    void destroy() {
        if (!this.isInitialized()) {
            return;
        }
        this.evictor.destroy();
    }

    @Override
    public boolean containsEntry(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public void removeEntry(Object key) {
        this.evictionCounter.increment();
        this.data.remove(key);
        this.ageStatistics.removeKey(key);
        this.sizeStatistics.removeKey(key);
    }

    @Override
    public long getMemorySize() {
        return this.sizeStatistics.getTotalSize();
    }

    @Override
    public Iterator<Object> getKeys() throws CacheException {
        return this.data.keySet().iterator();
    }
}

