/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomFunctionStep;
import com.cognos.cm.request.customFunctions.ICustomFunctionStep;
import com.cognos.cm.request.customFunctions.NoActionFunctionStep;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.iRequestHandler;
import com.ibm.cognos.pdc.cm.server.functionSteps.ClearFunctionStep;
import com.ibm.cognos.pdc.cm.server.functionSteps.CommitFunctionStep;
import com.ibm.cognos.pdc.cm.server.functionSteps.GetFunctionStep;
import com.ibm.cognos.pdc.cm.server.functionSteps.GetGridConfigurationStep;
import com.ibm.cognos.pdc.cm.server.functionSteps.ListGridsFunctionStep;
import com.ibm.cognos.pdc.cm.server.functionSteps.ListMapsFunctionStep;
import com.ibm.cognos.pdc.cm.server.functionSteps.ResetCountersFunctionStep;
import com.ibm.cognos.pdc.cm.server.functionSteps.ViewDataFunctionStep;
import com.ibm.cognos.pdc.cm.server.functionSteps.ViewDiagnosticsFunctionStep;
import com.ibm.cognos.pdc.core.PDCLogging;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public class PDCCustomFunction
extends CustomFunctionPlugin {
    protected boolean requireAdmin;
    private Map<String, Class<? extends CustomFunctionStep>> steps;

    public PDCCustomFunction(boolean requireAdmin, Map<String, Class<? extends CustomFunctionStep>> steps) {
        this.requireAdmin = requireAdmin;
        this.steps = steps;
    }

    protected ICustomFunctionStep getCustomFunctionStep(String name, String id, XMLElement stepSpecification) throws CMException {
        NoActionFunctionStep step = null;
        Class<? extends CustomFunctionStep> stepClass = this.steps.get(name);
        if (stepClass != null) {
            try {
                Constructor<? extends CustomFunctionStep> stepConstructor = stepClass.getConstructor(String.class, String.class, CustomFunctionPlugin.class, XMLElement.class);
                step = stepConstructor.newInstance(new Object[]{name, id, this, stepSpecification});
            }
            catch (NoSuchMethodException e) {
                PDCLogging.PDC_ERROR.log(Level.WARNING, "Unable to instantiate function step '" + name + "' because it doesn't have a compatible constructor.", e);
                throw new CMException((Exception)e);
            }
            catch (Exception e) {
                PDCLogging.PDC_ERROR.log(Level.WARNING, "Unable to instantiate function step '" + name + "'.", e);
                throw new CMException(e);
            }
        } else {
            PDCLogging.PDC_ERROR.log(Level.WARNING, "No function step named '" + name + "'.");
        }
        if (step == null) {
            step = new NoActionFunctionStep(name, id, (CustomFunctionPlugin)this);
        }
        return step;
    }

    protected void initialize() {
    }

    protected void initializeStep(String requestName, Element requestContent) {
    }

    public void run(List<XMLElement> functionSteps, OutputStream os) throws CMException, SAXException {
        if (this.requireAdmin && !CMExecutionContext.get().getCurrentUserIsAdministrator()) {
            throw new CMException("cmNoAdminCapability");
        }
        List steps = this.buildFunctionSteps(functionSteps);
        try {
            this.runSteps(steps, os);
        }
        catch (IOException e) {
            throw new CMRuntimeException((Throwable)e);
        }
    }

    public static class PDCRequests
    extends PDCCustomFunction {
        private static final Map<String, Class<? extends CustomFunctionStep>> steps = new HashMap<String, Class<? extends CustomFunctionStep>>();

        public PDCRequests(iRequestHandler handler) {
            super(false, steps);
        }

        static {
            steps.put("pdcClear", ClearFunctionStep.class);
            steps.put("pdcCommit", CommitFunctionStep.class);
            steps.put("pdcGet", GetFunctionStep.class);
            steps.put("getGridConfiguration", GetGridConfigurationStep.class);
        }
    }

    public static class PDCDiagnostics
    extends PDCCustomFunction {
        private static final Map<String, Class<? extends CustomFunctionStep>> steps = new HashMap<String, Class<? extends CustomFunctionStep>>();

        public PDCDiagnostics(iRequestHandler handler) {
            super(true, steps);
        }

        static {
            steps.put("viewDiagnostics", ViewDiagnosticsFunctionStep.class);
            steps.put("resetCounters", ResetCountersFunctionStep.class);
        }
    }

    public static class PDCBrowseGridData
    extends PDCCustomFunction {
        private static final Map<String, Class<? extends CustomFunctionStep>> steps = new HashMap<String, Class<? extends CustomFunctionStep>>();

        public PDCBrowseGridData(iRequestHandler handler) {
            super(true, steps);
        }

        static {
            steps.put("viewData", ViewDataFunctionStep.class);
            steps.put("listGrids", ListGridsFunctionStep.class);
            steps.put("listMaps", ListMapsFunctionStep.class);
        }
    }
}

