/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest;

import com.cognos.cm.rest.PropertyHandler;
import com.cognos.cm.server.CMException;
import com.ibm.cognos.pdc.cm.server.CMPDCGridManager;
import com.ibm.cognos.pdc.core.PDCBackendException;
import com.ibm.cognos.pdc.local.BackendGrid;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ccPagesPropertyHandler
implements PropertyHandler {
    private static final String CHARACTER_ENCODING = "UTF-8";
    static final String CC_PAGES = "ccPages";
    static final String PDCGRID_ID = "PDCGridID";
    private static final String SESSION = "~~";
    private int returnCode = 404;
    private String returnMsg = "Not Found";
    private String passport;

    public void handle(HttpServletRequest request, HttpServletResponse response, String path, String passport) throws CMException, IOException {
        this.assertPathIsSession(path);
        this.passport = passport;
        this.writeResponse(request, response);
    }

    private void writeResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        response.setCharacterEncoding(CHARACTER_ENCODING);
        Object sessionData = this.fetchSessionData(request);
        this.writeSessionData(response, sessionData);
    }

    private void writeSessionData(HttpServletResponse response, Object sessionData) throws IOException {
        if (sessionData != null) {
            response.setStatus(200);
            this.serialize(response, sessionData.toString());
        } else {
            response.sendError(this.returnCode, this.returnMsg);
        }
    }

    private void serialize(HttpServletResponse response, String value) throws IOException {
        byte[] bytes = this.getOutputBytes(value);
        this.writeOutput(response, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(HttpServletResponse response, byte[] bytes) throws IOException {
        OutputStream os = null;
        try {
            response.setContentLength(bytes.length);
            os = response.getOutputStream();
            os.write(bytes, 0, bytes.length);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private byte[] getOutputBytes(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes(CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return bytes;
    }

    private Object fetchSessionData(HttpServletRequest request) {
        Object sessionData = null;
        try {
            sessionData = this.getSessionData(request);
        }
        catch (PDCBackendException e) {
            this.returnCode = 500;
            this.returnMsg = e.getMessage();
        }
        return sessionData;
    }

    private void assertPathIsSession(String path) {
        if (!path.equals(SESSION)) {
            throw new IllegalStateException("The path is not support for property ccPages");
        }
    }

    protected Object getSessionData(HttpServletRequest request) throws PDCBackendException {
        BackendGrid backend = CMPDCGridManager.get().getBackendForGrid(this.getGridID(request));
        return backend.get(CC_PAGES, (Object)this.passport);
    }

    private String getGridID(HttpServletRequest request) {
        return request.getParameter(PDCGRID_ID);
    }
}

