/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client;

import com.ibm.cognos.pdc.BackingMap;
import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.PDCGrid;
import com.ibm.cognos.pdc.Session;
import com.ibm.cognos.pdc.SessionContext;
import com.ibm.cognos.pdc.cm.client.CMClientSideBackingMap;
import com.ibm.cognos.pdc.cm.client.CMServerInterface;
import com.ibm.cognos.pdc.cm.client.commands.CommandExecutor;
import com.ibm.cognos.pdc.core.PDCBackend;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.PDCSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMPDCGrid
implements PDCGrid {
    private Map<String, BackingMap> backingMaps;
    private CMServerInterface cmServer;
    private String gridId;
    private boolean isInitialized;

    public CMPDCGrid(String gridId) {
        this(gridId, null);
    }

    public CMPDCGrid(String gridId, CommandExecutor executor) {
        this.gridId = gridId;
        this.backingMaps = new HashMap<String, BackingMap>();
        this.cmServer = new CMServerInterface(executor);
    }

    public Session getSession(SessionContext context) throws CacheException {
        String passportId = context.getPassportId();
        if (passportId == null) {
            throw new IllegalArgumentException("CM Sessions require a passport id to be defined on the SessionContext");
        }
        return new PDCSession((PDCGrid)this, context, (PDCBackend)this.cmServer);
    }

    public String getGridId() {
        return this.gridId;
    }

    public List<String> getMapNames() {
        return new ArrayList<String>(this.backingMaps.keySet());
    }

    public BackingMap getBackingMap(String mapId) {
        BackingMap map = this.backingMaps.get(mapId);
        if (map == null && !this.isInitialized) {
            PDCLogging.PDC_DEBUG.info("Creating CMClientSideBackingMap for map id: " + mapId);
            map = new CMClientSideBackingMap(this, mapId);
            this.backingMaps.put(mapId, map);
        }
        return map;
    }

    public void initialize() {
        this.checkInitialized();
        this.cmServer.initialize(new ArrayList<BackingMap>(this.backingMaps.values()));
        this.isInitialized = true;
    }

    void checkInitialized() {
        if (this.isInitialized) {
            throw new IllegalStateException("Cannot change BackingMap after grid has been initialized.");
        }
    }
}

