/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client;

import com.ibm.cognos.pdc.BackingMap;
import com.ibm.cognos.pdc.PDCGrid;
import com.ibm.cognos.pdc.Session;
import com.ibm.cognos.pdc.cm.client.CMCommandFactory;
import com.ibm.cognos.pdc.cm.client.commands.ClearCommand;
import com.ibm.cognos.pdc.cm.client.commands.CommandExecutor;
import com.ibm.cognos.pdc.cm.client.commands.CommitCommand;
import com.ibm.cognos.pdc.cm.client.commands.GetCommand;
import com.ibm.cognos.pdc.cm.client.commands.P2pdCommandExecutor;
import com.ibm.cognos.pdc.core.MapChange;
import com.ibm.cognos.pdc.core.PDCBackend;
import com.ibm.cognos.pdc.core.PDCBackendException;
import java.util.List;

public class CMServerInterface
implements PDCBackend {
    private final CommandExecutor commandExecutor;
    private final CMCommandFactory commandFactory;

    public CMServerInterface(CMCommandFactory commandFactory, CommandExecutor commandExecutor) {
        this.commandFactory = commandFactory;
        this.commandExecutor = commandExecutor;
    }

    public CMServerInterface(CommandExecutor commandExecutor) {
        this(new CMCommandFactory(), null == commandExecutor ? new P2pdCommandExecutor() : commandExecutor);
    }

    public Object get(Session session, String mapId, Object key) throws PDCBackendException {
        Object value = null;
        PDCGrid grid = session.getPDCGrid();
        String gridId = grid.getGridId();
        String passportId = session.getSessionContext().getPassportId();
        GetCommand command = this.commandFactory.createGetCommand(gridId, mapId, key, passportId);
        command.execute(this.commandExecutor);
        value = command.getResultValue();
        return value;
    }

    public void commit(Session session, List<MapChange> mapChanges) throws PDCBackendException {
        PDCGrid parentGrid = session.getPDCGrid();
        String gridId = parentGrid.getGridId();
        String passportId = session.getSessionContext().getPassportId();
        CommitCommand commit = this.commandFactory.createCommitCommand(gridId, mapChanges, passportId);
        commit.execute(this.commandExecutor);
    }

    public void clear(Session session, String mapId) throws PDCBackendException {
        PDCGrid parentGrid = session.getPDCGrid();
        String gridId = parentGrid.getGridId();
        String passportId = session.getSessionContext().getPassportId();
        ClearCommand clear = this.commandFactory.createClearCommand(gridId, mapId, passportId);
        clear.execute(this.commandExecutor);
    }

    public List<String> getMapNames() {
        return null;
    }

    public void initialize(List<BackingMap> maps) {
    }
}

