/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client;

import com.ibm.cognos.pdc.CompoundKey;
import com.ibm.cognos.pdc.cm.SerializationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class ClientDeserializer {
    public Object deserialize(Element element) throws SerializationException {
        if (element.getName().equals("null")) {
            return null;
        }
        if (element.getName().equals("map")) {
            return this.deserializeMap(element);
        }
        if (element.getName().equals("collection")) {
            return this.deserializeCollection(element);
        }
        if (element.getName().equals("compoundKey")) {
            return this.deserializeCompoundKey(element);
        }
        return element.getText();
    }

    private Collection<Object> deserializeCollection(Element element) throws SerializationException {
        ArrayList<Object> result = new ArrayList<Object>();
        List children = element.elements();
        for (Element childValue : children) {
            result.add(this.deserialize(childValue));
        }
        return result;
    }

    private Map<Object, Object> deserializeMap(Element element) throws SerializationException {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        List children = element.elements();
        for (Element child : children) {
            Element keyValueEle = (Element)child.selectSingleNode("key/*[1]");
            if (keyValueEle == null) {
                throw new SerializationException("Error while parsing map, element key is missing mandatory child");
            }
            Element valueValueEle = (Element)child.selectSingleNode("value/*[1]");
            if (valueValueEle == null) {
                throw new SerializationException("Error while parsing map, element value is missing mandatory child");
            }
            Object key = this.deserialize(keyValueEle);
            Object value = this.deserialize(valueValueEle);
            result.put(key, value);
        }
        return result;
    }

    private CompoundKey deserializeCompoundKey(Element element) throws SerializationException {
        Element primaryKeyValueEle = (Element)element.selectSingleNode("primaryKey/*[1]");
        if (primaryKeyValueEle == null) {
            throw new SerializationException("Error while parsing CompoundKey, element primaryKey is missing mandatory child");
        }
        Element secondaryKeyValueEle = (Element)element.selectSingleNode("secondaryKey/*[1]");
        if (secondaryKeyValueEle == null) {
            throw new SerializationException("Error while parsing CompoundKey, element secondaryKey is missing mandatory child");
        }
        Object primaryKey = this.deserialize(primaryKeyValueEle);
        Object secondaryKey = this.deserialize(secondaryKeyValueEle);
        if (primaryKey == null || secondaryKey == null) {
            throw new SerializationException("CompoundKey must have non-null values.");
        }
        return new CompoundKey(primaryKey, secondaryKey);
    }
}

