/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client;

import com.ibm.cognos.pdc.cm.SerializationException;
import com.ibm.cognos.pdc.core.CMPDCTTLEvictor;
import com.ibm.cognos.pdc.core.eviction.Evictor;
import com.ibm.cognos.pdc.core.eviction.TTLType;
import org.dom4j.Element;

public class ClientEvictorDeserializer {
    public Evictor deserialize(Element evictorElement) throws SerializationException {
        String className = evictorElement.attributeValue("class");
        if (className == null) {
            throw new SerializationException("evictor element is missing mandatory attribute 'class'");
        }
        if (className.equals(CMPDCTTLEvictor.class.getName())) {
            return this.deserializeCMPDCTTLEVictor(evictorElement);
        }
        throw new SerializationException("Unknown Evictor class: " + className);
    }

    private Evictor deserializeCMPDCTTLEVictor(Element evictorElement) throws SerializationException {
        float evictionPercent;
        int sleepTime;
        int ttlTime;
        CMPDCTTLEvictor evictor = new CMPDCTTLEvictor();
        String ttlTypeString = this.getMandatoryElementText(evictorElement, "ttlType");
        TTLType ttlType = TTLType.valueOf((String)ttlTypeString);
        if (ttlType == null) {
            throw new SerializationException("Unrecognized TTLType: " + ttlTypeString);
        }
        evictor.setTTLType(ttlType);
        String ttlTimeString = this.getMandatoryElementText(evictorElement, "timeToLive");
        try {
            ttlTime = Integer.parseInt(ttlTimeString);
        }
        catch (NumberFormatException e) {
            throw new SerializationException("Unable to parse timeToLive value: " + ttlTimeString);
        }
        evictor.setTimeToLive(ttlTime);
        String sleepTimeString = this.getMandatoryElementText(evictorElement, "sleepTime");
        try {
            sleepTime = Integer.parseInt(sleepTimeString);
        }
        catch (NumberFormatException e) {
            throw new SerializationException("Unable to parse sleepTime value: " + sleepTimeString);
        }
        evictor.setSleepTimeSecs(sleepTime);
        String evictionPercentString = this.getMandatoryElementText(evictorElement, "evictionPercent");
        try {
            evictionPercent = Float.parseFloat(evictionPercentString);
        }
        catch (NumberFormatException e) {
            throw new SerializationException("Unable to parse evictionPercent value: " + evictionPercentString);
        }
        evictor.setPercentageToEvictWhenMemoryIsLow(evictionPercent);
        return evictor;
    }

    private String getMandatoryElementText(Element element, String childName) throws SerializationException {
        String result = element.elementText(childName);
        if (result == null) {
            throw new SerializationException(element.getName() + " element is missing mandatory child text, child element: '" + childName + "'");
        }
        return result;
    }
}

