/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client;

import com.ibm.cognos.pdc.CompoundKey;
import java.util.Collection;
import java.util.Map;
import org.dom4j.Element;

public class ClientSerializer {
    public void serialize(Element parent, Object result) {
        if (result == null) {
            parent.addElement("null");
        } else if (result instanceof Map) {
            this.serialize(parent, (Map)result);
        } else if (result instanceof Collection) {
            this.serialize(parent, (Collection)result);
        } else if (result instanceof CompoundKey) {
            this.serialize(parent, (CompoundKey)result);
        } else {
            Element string = parent.addElement("string");
            string.setText(result.toString());
        }
    }

    private void serialize(Element parent, Map<?, ?> map) {
        Element mapEle = parent.addElement("map");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Element entryEle = mapEle.addElement("entry");
            Element keyEle = entryEle.addElement("key");
            this.serialize(keyEle, entry.getKey());
            Element valueEle = entryEle.addElement("value");
            this.serialize(valueEle, entry.getValue());
        }
    }

    private void serialize(Element parent, Collection<?> collection) {
        Element collectionEle = parent.addElement("collection");
        for (Object value : collection) {
            this.serialize(collectionEle, value);
        }
    }

    private void serialize(Element parent, CompoundKey key) {
        Element compoundKeyEle = parent.addElement("compoundKey");
        Element primaryKeyEle = compoundKeyEle.addElement("primaryKey");
        this.serialize(primaryKeyEle, key.getPrimaryKey());
        Element secondaryKeyEle = compoundKeyEle.addElement("secondaryKey");
        this.serialize(secondaryKeyEle, key.getSecondaryKey());
    }
}

