/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client.commands;

import com.ibm.cognos.pdc.cm.client.CMBackendException;
import com.ibm.cognos.pdc.cm.client.commands.CommandExecutor;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public abstract class CMPDCCommand {
    public static final Namespace BUS_NAMESPACE = new Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
    private static final Namespace NS_XSD = Namespace.get((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private static final Namespace NS_XSI = Namespace.get((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static final QName XSI_TYPE = DocumentHelper.createQName((String)"type", (Namespace)NS_XSI);
    public static final String XSD_STRING = NS_XSD.getPrefix() + ":string";
    public static final QName XSI_NIL = DocumentHelper.createQName((String)"nil", (Namespace)NS_XSI);
    protected static final String CUSTOM_FUNCTION = "customFunction";
    protected static final String FUNCTION_STEP = "functionStep";
    protected static final String GRID_ID = "gridID";
    protected static final QName BUS_CUSTOM = new QName("custom", BUS_NAMESPACE);
    protected static final QName BUS_CUSTOM_RESPONSE = new QName("customResponse", BUS_NAMESPACE);
    protected final String stepName;
    protected final String gridId;
    private String passportId;
    private String customFunction;

    public CMPDCCommand(String customFunction, String stepName, String gridId, String passportId) {
        this.customFunction = customFunction;
        this.stepName = stepName;
        this.gridId = gridId;
        this.passportId = passportId;
    }

    public void execute(CommandExecutor commandExecutor) throws CMBackendException {
        commandExecutor.executeCommand(this);
    }

    public void fillInSoapBody(Element bodyElement) {
        Element customElement = bodyElement.addElement(BUS_CUSTOM);
        this.addElementAndTextTo(customElement, CUSTOM_FUNCTION, XSD_STRING, this.customFunction);
        Element functionStepsElement = customElement.addElement("functionSteps");
        Element functionStep = this.addFunctionStepTo(functionStepsElement, this.stepName, 1);
        this.addElementAndTextTo(functionStep, GRID_ID, XSD_STRING, this.gridId);
        this.populateFunctionStep(functionStep);
    }

    public void handleResponse(Element bodyElement) throws CMBackendException {
        Element custom = bodyElement.element(BUS_CUSTOM_RESPONSE);
        if (custom == null) {
            throw new CMBackendException("Missing required element customResponse");
        }
        Element responses = custom.element("responses");
        if (responses == null) {
            throw new CMBackendException("Missing required element responses");
        }
        Element response = responses.element("response");
        if (response == null) {
            throw new CMBackendException("Missing required element response");
        }
        this.checkForException(response);
        this.processResponse(response);
    }

    private void checkForException(Element response) throws CMBackendException {
        Element exceptionElement = response.element("exception");
        if (exceptionElement != null) {
            String message = null;
            Element messageStringElement = (Element)exceptionElement.selectSingleNode("message/string");
            if (messageStringElement != null) {
                message = messageStringElement.getText();
            }
            if (message == null) {
                message = "No exception message was provided by the server.";
            }
            throw new CMBackendException(message);
        }
    }

    protected Element addFunctionStepTo(Element functionStepsElement, String name, int id) {
        Element result = functionStepsElement.addElement(FUNCTION_STEP);
        result.addAttribute("name", name);
        result.addAttribute("id", String.valueOf(id));
        return result;
    }

    protected Element addElementAndTextTo(Element parent, String name, String xsiType, String text) {
        Element result = parent.addElement(name);
        result.addAttribute(XSI_TYPE, xsiType);
        if (text != null) {
            result.setText(text);
        }
        return result;
    }

    public String getPassport() {
        return this.passportId;
    }

    public String getCustomFunctionName() {
        return this.customFunction;
    }

    protected abstract void populateFunctionStep(Element var1);

    protected abstract void processResponse(Element var1) throws CMBackendException;
}

