/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client.commands;

import com.ibm.cognos.pdc.cm.client.CMBackendException;
import com.ibm.cognos.pdc.cm.client.ClientSerializer;
import com.ibm.cognos.pdc.cm.client.commands.CMPDCCommand;
import com.ibm.cognos.pdc.core.MapChange;
import com.ibm.cognos.pdc.core.WriteOperation;
import java.util.List;
import org.dom4j.Element;

public class CommitCommand
extends CMPDCCommand {
    private static ClientSerializer serializer = new ClientSerializer();
    private List<MapChange> mapChanges;

    public CommitCommand(String gridId, String passportId, List<MapChange> mapChanges) {
        super("PDCCustomFunction$PDCRequests", "pdcCommit", gridId, passportId);
        this.mapChanges = mapChanges;
    }

    @Override
    protected void populateFunctionStep(Element functionStep) {
        Element operationsElement = functionStep.addElement("operations");
        for (MapChange mapChange : this.mapChanges) {
            String mapId = mapChange.getMapId();
            List writeOperations = mapChange.getWriteOperations();
            for (WriteOperation operation : writeOperations) {
                Object key = operation.getKey();
                Element operationElement = operationsElement.addElement("operation");
                this.addElementAndTextTo(operationElement, "name", null, operation.getOperationName());
                Element argumentsElement = operationElement.addElement("arguments");
                this.addElementAndTextTo(argumentsElement, "mapID", null, mapId);
                Element keyEle = argumentsElement.addElement("key");
                serializer.serialize(keyEle, key);
                if (operation.includeValueInCommit()) {
                    Element valueEle = argumentsElement.addElement("value");
                    Object newValue = operation.getNewValue();
                    serializer.serialize(valueEle, newValue);
                }
                Object firstValue = operation.getFirstReadValue();
                Element firstReadEle = argumentsElement.addElement("firstReadValue");
                serializer.serialize(firstReadEle, firstValue);
            }
        }
    }

    @Override
    protected void processResponse(Element response) throws CMBackendException {
    }
}

