/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client.commands;

import com.ibm.cognos.pdc.cm.SerializationException;
import com.ibm.cognos.pdc.cm.client.CMBackendException;
import com.ibm.cognos.pdc.cm.client.ClientDeserializer;
import com.ibm.cognos.pdc.cm.client.ClientSerializer;
import com.ibm.cognos.pdc.cm.client.commands.CMPDCCommand;
import java.util.List;
import org.dom4j.Element;

public class GetCommand
extends CMPDCCommand {
    private static ClientDeserializer deserializer = new ClientDeserializer();
    private static ClientSerializer serializer = new ClientSerializer();
    private final Object key;
    private final String mapId;
    private Object resultValue;

    public GetCommand(String gridId, String mapId, Object key, String passportId) {
        super("PDCCustomFunction$PDCRequests", "pdcGet", gridId, passportId);
        this.mapId = mapId;
        this.key = key;
    }

    @Override
    protected void populateFunctionStep(Element functionStep) {
        this.addElementAndTextTo(functionStep, "mapID", XSD_STRING, this.mapId);
        Element keyEle = functionStep.addElement("key");
        serializer.serialize(keyEle, this.key);
    }

    @Override
    protected void processResponse(Element response) throws CMBackendException {
        Element result = response.element("result");
        if (result == null) {
            throw new CMBackendException("Response is missing required result element");
        }
        List values = result.elements();
        if (values.size() == 0) {
            throw new CMBackendException("Response is missing required element, \"result\" must have a child element");
        }
        try {
            Object value = deserializer.deserialize((Element)values.get(0));
            this.setResultValue(value);
        }
        catch (SerializationException e) {
            throw new CMBackendException((Throwable)((Object)e));
        }
    }

    protected void setResultValue(Object value) {
        this.resultValue = value;
    }

    public Object getResultValue() {
        return this.resultValue;
    }
}

