/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client.commands;

import com.ibm.cognos.pdc.BackingMap;
import com.ibm.cognos.pdc.cm.SerializationException;
import com.ibm.cognos.pdc.cm.client.CMBackendException;
import com.ibm.cognos.pdc.cm.client.CMClientSideBackingMap;
import com.ibm.cognos.pdc.cm.client.ClientEvictorDeserializer;
import com.ibm.cognos.pdc.cm.client.commands.CMPDCCommand;
import com.ibm.cognos.pdc.core.eviction.EvictionTriggers;
import com.ibm.cognos.pdc.core.eviction.Evictor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.dom4j.Element;

public class GetGridConfigurationCommand
extends CMPDCCommand {
    protected static ClientEvictorDeserializer evictorDeserializer = new ClientEvictorDeserializer();
    private boolean gridIsConfigured;
    private List<BackingMap> backingMaps;

    public GetGridConfigurationCommand(String gridId, String passportId) {
        super("PDCCustomFunction$PDCRequests", "getGridConfiguration", gridId, passportId);
    }

    public boolean isGridConfigured() {
        return this.gridIsConfigured;
    }

    public List<BackingMap> getBackingMaps() {
        return this.backingMaps;
    }

    @Override
    protected void populateFunctionStep(Element functionStep) {
    }

    @Override
    protected void processResponse(Element response) throws CMBackendException {
        Element result = response.element("result");
        if (result == null) {
            throw new CMBackendException("Response is missing required result element");
        }
        Element grid = result.element("grid");
        if (grid == null) {
            throw new CMBackendException("Response is missing required element: result/grid");
        }
        String configState = grid.attributeValue("configurationState");
        if (configState == null) {
            throw new CMBackendException("grid element is missing required attribute 'id'");
        }
        this.gridIsConfigured = configState.equals("configured");
        if (!this.gridIsConfigured) {
            return;
        }
        List mapElements = grid.elements("map");
        this.backingMaps = new ArrayList<BackingMap>(mapElements.size());
        for (Element mapElement : mapElements) {
            this.backingMaps.add(this.parseMap(mapElement));
        }
    }

    private BackingMap parseMap(Element mapElement) throws CMBackendException {
        String mapId = mapElement.attributeValue("id");
        if (mapId == null) {
            throw new CMBackendException("map element is missing required attribute 'id'");
        }
        CMClientSideBackingMap map = new CMClientSideBackingMap(mapId);
        this.parseEvictionTriggers(mapElement, map);
        this.parseEvictor(mapElement, map);
        return map;
    }

    private void parseEvictor(Element mapElement, CMClientSideBackingMap map) throws CMBackendException {
        Element evictorElement = mapElement.element("evictor");
        if (evictorElement != null) {
            try {
                Evictor evictor = evictorDeserializer.deserialize(evictorElement);
                map.setEvictor(evictor);
            }
            catch (SerializationException e) {
                throw new CMBackendException("Unable to parse evictor", (Throwable)((Object)e));
            }
        }
    }

    private void parseEvictionTriggers(Element mapElement, CMClientSideBackingMap map) throws CMBackendException {
        EnumSet<EvictionTriggers> evictionTriggers = EnumSet.noneOf(EvictionTriggers.class);
        List triggerElements = mapElement.selectNodes("evictionTriggers/evictionTrigger");
        for (Element triggerElement : triggerElements) {
            String triggerText = triggerElement.getText();
            if (triggerText == null) {
                throw new CMBackendException("evictionTrigger element must have text");
            }
            EvictionTriggers trigger = EvictionTriggers.valueOf((String)triggerText);
            if (trigger == null) {
                throw new CMBackendException("Unknown evictionTrigger: '" + triggerText + "'");
            }
            evictionTriggers.add(trigger);
        }
        map.setEvictionTriggers(evictionTriggers);
    }
}

