/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.client.commands;

import com.cognos.pogo.http.ServerConnection;
import com.ibm.cognos.pdc.cm.client.CMBackendException;
import com.ibm.cognos.pdc.cm.client.commands.CommandExecutor;
import com.ibm.cognos.pdc.cm.client.commands.GetCommand;
import com.ibm.cognos.pdc.cm.client.commands.P2pdCommandFacade;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.dom4j.Element;

public class RestfulGetCommand
extends GetCommand {
    private P2pdCommandFacade p2pdCommand = new P2pdCommandFacade(this);

    public RestfulGetCommand(String gridId, String mapId, Object key, String passportId) {
        super(gridId, mapId, key, passportId);
    }

    protected void setCommandFacade(P2pdCommandFacade p2pdCommand) {
        this.p2pdCommand = p2pdCommand;
    }

    @Override
    public void execute(CommandExecutor ignored) throws CMBackendException {
        block8: {
            ServerConnection conn = this.p2pdCommand.getServerConnection();
            HttpClient http = conn.getHttpClient();
            HttpMethod method = this.setupHttpMethod();
            int httpCode = 404;
            try {
                httpCode = http.executeMethod(method);
                if (httpCode == 200) {
                    this.setResultValue(method.getResponseBodyAsString());
                    break block8;
                }
                if (httpCode == 404) {
                    this.setResultValue(null);
                    break block8;
                }
                throw new CMBackendException("Unexpected HTTP response (" + httpCode + ")");
            }
            catch (HttpException e) {
                throw new CMBackendException(e);
            }
            catch (IOException e) {
                throw new CMBackendException(e);
            }
            finally {
                conn.release();
            }
        }
    }

    private HttpMethod setupHttpMethod() {
        String uri = this.getCMRestServletUri() + "/1.0/objects/~~/ccPages?PDCGridID=" + this.gridId;
        GetMethod method = this.p2pdCommand.getHttpGetMethod(uri);
        method.addRequestHeader("X-Cognos-CAM-passportID", this.getPassport());
        return method;
    }

    private String getCMRestServletUri() {
        return this.p2pdCommand.getRequestContext().replace("/servlet", "/cm");
    }

    @Override
    protected void populateFunctionStep(Element functionStep) {
    }

    @Override
    protected void processResponse(Element response) throws CMBackendException {
    }
}

