/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server;

import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.local.BackendFactory;
import com.ibm.cognos.pdc.local.BackendGrid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMPDCGridManager {
    public static CMPDCGridManager INSTANCE = new CMPDCGridManager();
    protected static BackendFactory factory = new BackendFactory();
    private Map<String, BackendGrid> grids = new HashMap<String, BackendGrid>();

    public static CMPDCGridManager get() {
        return INSTANCE;
    }

    public synchronized BackendGrid getBackendForGrid(String gridId) {
        BackendGrid grid = this.grids.get(gridId.toUpperCase());
        if (grid == null) {
            PDCLogging.PDC_DEBUG.finest("Creating BackendGrid for grid id: " + gridId);
            grid = factory.createBackendGrid(gridId);
            this.grids.put(gridId.toUpperCase(), grid);
        }
        return grid;
    }

    public synchronized List<String> getGridIds() {
        ArrayList<String> result = new ArrayList<String>(this.grids.size());
        for (BackendGrid grid : this.grids.values()) {
            result.add(grid.getId());
        }
        return result;
    }

    public static void reset_TEST() {
        INSTANCE = new CMPDCGridManager();
    }

    public void setGrid_TEST(String gridId, BackendGrid grid) {
        this.grids.put(gridId.toUpperCase(), grid);
    }
}

