/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server;

import com.cognos.cm.util.CMIndentedPrintStream;
import com.ibm.cognos.pdc.cm.server.ServerSerializer;
import com.ibm.cognos.pdc.local.BackendGrid;
import com.ibm.cognos.pdc.local.BackendGridVisitor;
import com.ibm.cognos.pdc.local.BackendMap;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResponseGeneratingGridVisitor
implements BackendGridVisitor {
    private static ServerSerializer serializer = new ServerSerializer();
    private List<Object> keys;
    private CMIndentedPrintStream out;
    private Map<String, Set<String>> gridToMapIds;

    public ResponseGeneratingGridVisitor(CMIndentedPrintStream out) {
        this(out, null, null);
    }

    public ResponseGeneratingGridVisitor(CMIndentedPrintStream out, List<Object> keys, Map<String, Set<String>> gridToMapIds) {
        this.out = out;
        this.keys = keys;
        this.gridToMapIds = gridToMapIds;
    }

    public void visitGrid(BackendGrid grid) {
        this.out.println("<grid id=\"" + grid.getId() + "\">");
        this.out.indent();
    }

    public void visitMap(BackendMap map) {
        this.out.println("<map id=\"" + map.getName() + "\">");
    }

    public void visitMapEntry(Object key, Object value) {
        this.out.indent();
        this.out.println("<entry>");
        this.out.indent();
        this.out.print("<key>");
        serializer.serialize((PrintStream)this.out, key);
        this.out.println("</key>");
        this.out.print("<value>");
        serializer.serialize((PrintStream)this.out, value);
        this.out.println("</value>");
        this.out.unindent();
        this.out.println("</entry>");
        this.out.unindent();
    }

    public void leaveMap(BackendMap map) {
        this.out.println("</map>");
    }

    public void leaveGrid(BackendGrid grid) {
        this.out.unindent();
        this.out.println("</grid>");
    }

    public List<Object> getKeysToVisit() {
        return this.keys;
    }

    public Set<String> getMapsToVisitForGrid(String gridId) {
        return this.gridToMapIds.get(gridId);
    }
}

