/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.ibm.cognos.pdc.CompoundKey;
import com.ibm.cognos.pdc.cm.SerializationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ServerDeserializer {
    public Object deserializeValueElement(XMLElement element) throws CMException, SerializationException {
        return this.deserializeValueElement(element, null);
    }

    public Object deserializeValueElement(XMLElement element, SizeCounter counter) throws CMException, SerializationException {
        XMLElement child = element.getChild(0);
        if (child == null) {
            throw new SerializationException("Missing mandatory child element");
        }
        return this.deserialize(child, counter);
    }

    public Object deserialize(XMLElement element) throws CMException, SerializationException {
        return this.deserialize(element, null);
    }

    public Object deserialize(XMLElement element, SizeCounter counter) throws CMException, SerializationException {
        if (element.name_.equals("null")) {
            return null;
        }
        if (element.name_.equals("map")) {
            return this.deserializeMap(element, counter);
        }
        if (element.name_.equals("collection")) {
            return this.deserializeCollection(element, counter);
        }
        if (element.name_.equals("compoundKey")) {
            return this.deserializeCompoundKey(element, counter);
        }
        return this.deserializeString(element, counter);
    }

    public Collection<Object> deserializeCollection(XMLElement element) throws CMException, SerializationException {
        return this.deserializeCollection(element, null);
    }

    public Collection<Object> deserializeCollection(XMLElement element, SizeCounter counter) throws CMException, SerializationException {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList children = element.getChildren();
        for (XMLElement childValue : children) {
            result.add(this.deserialize(childValue, counter));
        }
        return result;
    }

    public Map<Object, Object> deserializeMap(XMLElement element) throws CMException, SerializationException {
        return this.deserializeMap(element, null);
    }

    public Map<Object, Object> deserializeMap(XMLElement element, SizeCounter counter) throws CMException, SerializationException {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        ArrayList children = element.getChildren();
        for (XMLElement child : children) {
            XMLElement keyEle = child.getChildWithName("key");
            XMLElement keyValueEle = keyEle.getChild(0);
            if (keyValueEle == null) {
                throw new SerializationException("Error while parsing map, element key is missing mandatory child");
            }
            XMLElement valueEle = child.getChildWithName("value");
            XMLElement valueValueEle = valueEle.getChild(0);
            if (valueValueEle == null) {
                throw new SerializationException("Error while parsing map, element value is missing mandatory child");
            }
            Object key = this.deserialize(keyValueEle, counter);
            Object value = this.deserialize(valueValueEle, counter);
            result.put(key, value);
        }
        return result;
    }

    public CompoundKey deserializeCompoundKey(XMLElement element) throws CMException, SerializationException {
        return this.deserializeCompoundKey(element, null);
    }

    public CompoundKey deserializeCompoundKey(XMLElement element, SizeCounter counter) throws CMException, SerializationException {
        XMLElement primaryKeyEle = element.getChildWithName("primaryKey");
        XMLElement primaryKeyValueEle = primaryKeyEle.getChild(0);
        if (primaryKeyValueEle == null) {
            throw new SerializationException("Error while parsing map, element primaryKey is missing mandatory child");
        }
        XMLElement secondaryKeyEle = element.getChildWithName("secondaryKey");
        XMLElement secondaryKeyValueEle = secondaryKeyEle.getChild(0);
        if (secondaryKeyValueEle == null) {
            throw new SerializationException("Error while parsing map, element secondaryKey is missing mandatory child");
        }
        KeySizeCounter keyCounter = null;
        if (counter != null && counter instanceof KeySizeCounter) {
            keyCounter = (KeySizeCounter)counter;
            keyCounter.setIsCompoundKey(true);
        }
        Object primaryKey = this.deserialize(primaryKeyValueEle, counter);
        if (keyCounter != null) {
            keyCounter.switchToSecondaryKey();
        }
        Object secondaryKey = this.deserialize(secondaryKeyValueEle, counter);
        if (primaryKey == null || secondaryKey == null) {
            throw new SerializationException("CompoundKey must have non-null values.");
        }
        return new CompoundKey(primaryKey, secondaryKey);
    }

    public String deserializeString(XMLElement element) {
        return this.deserializeString(element, null);
    }

    public String deserializeString(XMLElement element, SizeCounter counter) {
        String value;
        String string = value = element.value_ == null ? "" : element.value_;
        if (counter != null) {
            counter.add(value.length());
        }
        return value;
    }

    public static class KeySizeCounter
    extends SizeCounter {
        private boolean isCompoundKey;
        private long primaryKeySize;
        private long secondaryKeySize;
        private boolean isParsingSecondaryKey;

        @Override
        protected void add(long delta) {
            if (!this.isParsingSecondaryKey) {
                this.primaryKeySize += delta;
            } else {
                this.secondaryKeySize += delta;
            }
        }

        public void switchToSecondaryKey() {
            this.isParsingSecondaryKey = true;
        }

        public void setIsCompoundKey(boolean isCompoundKey) {
            this.isCompoundKey = isCompoundKey;
        }

        public boolean isCompoundKey() {
            return this.isCompoundKey;
        }

        @Override
        public long getSize() {
            return this.primaryKeySize + this.secondaryKeySize;
        }

        public long getPrimaryKeySize() {
            return this.primaryKeySize;
        }

        public long getSecondaryKeySize() {
            return this.secondaryKeySize;
        }
    }

    public static class SizeCounter {
        private long size;

        public long getSize() {
            return this.size;
        }

        protected void add(long delta) {
            this.size += delta;
        }
    }
}

