/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server;

import com.cognos.cm.util.CMXMLUtils;
import com.ibm.cognos.pdc.CompoundKey;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;

public class ServerSerializer {
    public static final String ELEM_RESULT_NULL = "<null />";

    public void serialize(PrintStream out, Object result) {
        if (result == null) {
            out.print(ELEM_RESULT_NULL);
        } else if (result instanceof Map) {
            this.serialize(out, (Map)result);
        } else if (result instanceof Collection) {
            this.serialize(out, (Collection)result);
        } else if (result instanceof CompoundKey) {
            this.serialize(out, (CompoundKey)result);
        } else {
            this.serialize(out, result.toString());
        }
    }

    public void serialize(PrintStream os, Map<?, ?> map) {
        os.print("<map>");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            os.print("<entry>");
            os.print("<key>");
            this.serialize(os, entry.getKey());
            os.print("</key>");
            os.print("<value>");
            this.serialize(os, entry.getValue());
            os.print("</value>");
            os.print("</entry>");
        }
        os.print("</map>");
    }

    public void serialize(PrintStream os, Collection<?> collection) {
        os.print("<collection>");
        for (Object value : collection) {
            this.serialize(os, value);
        }
        os.print("</collection>");
    }

    public void serialize(PrintStream os, CompoundKey key) {
        os.print("<compoundKey>");
        os.print("<primaryKey>");
        this.serialize(os, key.getPrimaryKey());
        os.print("</primaryKey>");
        os.print("<secondaryKey>");
        this.serialize(os, key.getSecondaryKey());
        os.print("</secondaryKey>");
        os.print("</compoundKey>");
    }

    public void serialize(PrintStream out, String value) {
        byte[] bytes;
        String encodedValue = CMXMLUtils.encode((String)value);
        try {
            bytes = encodedValue.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            bytes = encodedValue.getBytes();
        }
        out.print("<string>");
        out.write(bytes, 0, bytes.length);
        out.print("</string>");
    }

    public void serialize(PrintStream out, Exception exception) {
        out.println("<exception>");
        out.print("<class>");
        this.serialize(out, exception.getClass().getName());
        out.println("</class>");
        out.print("<message>");
        this.serialize(out, exception.getLocalizedMessage());
        out.println("</message>");
        out.print("</exception>");
    }
}

