/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server.functionSteps;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomFunctionStep;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.ibm.cognos.pdc.cm.server.PDCServerDiagnostics;
import com.ibm.cognos.pdc.core.ICounter;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.diagnostics.DiagnosticGrid;
import com.ibm.cognos.pdc.core.diagnostics.DiagnosticMap;
import com.ibm.cognos.pdc.core.diagnostics.PDCDiagnostics;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public abstract class AbstractDiagnosticsFunctionStep
extends CustomFunctionStep {
    protected static PDCDiagnostics diagnostics = PDCServerDiagnostics.DIAGNOSTICS;
    protected List<ICounter> globalCounters = new ArrayList<ICounter>();
    protected List<String> mapCounters;
    protected boolean allMapCounters;
    protected List<DiagnosticGrid> grids = new ArrayList<DiagnosticGrid>();

    public AbstractDiagnosticsFunctionStep(String _name, String _id, CustomFunctionPlugin _plugin, XMLElement stepSpecification) throws CMException {
        super(_name, _id, _plugin);
        this.mapCounters = new ArrayList<String>();
        this.initialize();
        this.parse(stepSpecification);
    }

    protected void initialize() {
    }

    private void parse(XMLElement stepSpecification) throws CMException {
        XMLElement diagnosticsElement = stepSpecification.getChildWithName("diagnostics");
        if (diagnosticsElement == null) {
            throw (CMException)PDCLogging.logAndReturnException((Logger)PDCLogging.PDC_ERROR, (Level)Level.WARNING, (Exception)new CMException("Error parsing customFunction step. Missing required element 'diagnostics'."));
        }
        this.parseGlobalElement(diagnosticsElement);
        this.parseGrids(diagnosticsElement);
        XMLElement optionsElement = diagnosticsElement.getOptionalChildWithName("options");
        if (optionsElement != null) {
            this.parseOptions(optionsElement);
        }
    }

    protected void parseOptions(XMLElement optionsElement) throws CMException {
        XMLElement countersElement = optionsElement.getOptionalChildWithName("counters");
        if (countersElement != null) {
            ArrayList counters;
            String allCountersString = countersElement.getAttribute("all");
            boolean bl = this.allMapCounters = allCountersString != null && Boolean.parseBoolean(allCountersString);
            if (!this.allMapCounters && (counters = countersElement.getChildrenAllShouldBe("counter")) != null) {
                for (XMLElement counter : counters) {
                    this.mapCounters.add(this.getId(counter));
                }
            }
        }
    }

    private void parseGrids(XMLElement countersElement) throws CMException {
        ArrayList gridElements;
        XMLElement gridsElement = countersElement.getOptionalChildWithName("grids");
        if (gridsElement != null && (gridElements = gridsElement.getChildrenAllShouldBe("grid")) != null) {
            for (XMLElement gridElement : gridElements) {
                DiagnosticGrid grid = this.parseGrid(gridElement);
                if (grid == null) continue;
                this.grids.add(grid);
            }
        }
    }

    protected DiagnosticGrid parseGrid(XMLElement gridElement) throws CMException {
        String gridId = this.getId(gridElement);
        DiagnosticGrid grid = diagnostics.getDiagnosticGrid(gridId);
        if (grid == null) {
            return null;
        }
        XMLElement mapsElement = gridElement.getChildWithName("maps");
        String allMapsString = mapsElement.getAttribute("all");
        if (allMapsString == null || !Boolean.parseBoolean(allMapsString)) {
            WriteableDiagnosticGrid writeableGrid = new WriteableDiagnosticGrid(grid.getId());
            ArrayList mapElements = mapsElement.getChildrenAllShouldBe("map");
            if (mapElements != null) {
                for (XMLElement mapElement : mapElements) {
                    DiagnosticMap map = this.parseMap(mapElement, grid);
                    if (map == null) continue;
                    writeableGrid.addMap(map);
                }
            }
            grid = writeableGrid;
        }
        return grid;
    }

    protected DiagnosticMap parseMap(XMLElement mapElement, DiagnosticGrid parentGrid) throws CMException {
        String mapId = this.getId(mapElement);
        DiagnosticMap map = parentGrid.getMap(mapId);
        return map;
    }

    private void parseGlobalElement(XMLElement rootElement) throws CMException {
        XMLElement globalElement = rootElement.getOptionalChildWithName("global");
        if (globalElement != null) {
            this.parseGlobalCounters(globalElement);
        }
    }

    private void parseGlobalCounters(XMLElement globalElement) throws CMException {
        XMLElement countersElement = globalElement.getOptionalChildWithName("counters");
        if (countersElement != null) {
            String allAttribute = countersElement.getAttribute("all");
            if (allAttribute != null && Boolean.parseBoolean(allAttribute)) {
                this.globalCounters.addAll(diagnostics.getGlobalCounters());
            } else {
                ArrayList counterElements = countersElement.getChildrenAllShouldBe("counter");
                if (counterElements != null) {
                    for (XMLElement counterElement : counterElements) {
                        String counterId = this.getId(counterElement);
                        ICounter globalCounter = diagnostics.getGlobalCounter(counterId);
                        if (globalCounter == null) continue;
                        this.globalCounters.add(globalCounter);
                    }
                }
            }
        }
    }

    protected String getId(XMLElement element) throws CMException {
        String id = element.getAttribute("id");
        if (id == null) {
            throw (CMException)PDCLogging.logAndReturnException((Logger)PDCLogging.PDC_ERROR, (Level)Level.WARNING, (Exception)new CMException("cmExpectedAttributeMissing", new CMException.Parm[]{new CMException.Parm("Name", "id"), new CMException.Parm("Element", element.name_)}));
        }
        return id;
    }

    public abstract void runFunctionStep(OutputStream var1) throws SAXException, CMException;

    protected static class WriteableDiagnosticGrid
    extends DiagnosticGrid {
        public WriteableDiagnosticGrid(String id) {
            super(id);
        }

        public void addMap(DiagnosticMap map) {
            super.addMap(map);
        }
    }
}

