/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server.functionSteps;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.ibm.cognos.pdc.cm.server.CMPDCGridManager;
import com.ibm.cognos.pdc.cm.server.ServerSerializer;
import com.ibm.cognos.pdc.cm.server.functionSteps.InPDCServerMeasuringFunctionStep;
import com.ibm.cognos.pdc.core.PDCBackendException;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.local.BackendGrid;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import org.xml.sax.SAXException;

public class ClearFunctionStep
extends InPDCServerMeasuringFunctionStep {
    private static ServerSerializer serializer = new ServerSerializer();
    private CMPDCGridManager gridManager;
    private String gridID_;
    private String mapID_;
    private XMLElement stepSpecification;

    public ClearFunctionStep(String name, String id, CustomFunctionPlugin pdcClear, XMLElement stepSpecification) {
        this(name, id, pdcClear, stepSpecification, null);
    }

    protected ClearFunctionStep(String name, String id, CustomFunctionPlugin pdcClear, XMLElement stepSpecification, CMPDCGridManager manager) {
        super(name, id, pdcClear);
        this.stepSpecification = stepSpecification;
        this.gridManager = manager == null ? CMPDCGridManager.get() : manager;
    }

    protected void parse() throws CMException {
        this.gridID_ = this.stepSpecification.getChildValueWithName("gridID");
        this.mapID_ = this.stepSpecification.getChildValueWithName("mapID");
    }

    @Override
    public void runFunctionStepImpl(OutputStream os) throws SAXException, CMException {
        this.parse();
        BackendGrid backend = this.gridManager.getBackendForGrid(this.getGridID());
        try {
            backend.clear(this.getMapID());
        }
        catch (PDCBackendException e) {
            serializer.serialize(new PrintStream(os), (Exception)((Object)e));
            PDCLogging.PDC_ERROR.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    public String getGridID() {
        return this.gridID_;
    }

    public String getMapID() {
        return this.mapID_;
    }
}

