/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server.functionSteps;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.ibm.cognos.pdc.cm.SerializationException;
import com.ibm.cognos.pdc.cm.server.CMPDCGridManager;
import com.ibm.cognos.pdc.cm.server.CMServerMapChange;
import com.ibm.cognos.pdc.cm.server.ServerDeserializer;
import com.ibm.cognos.pdc.cm.server.ServerSerializer;
import com.ibm.cognos.pdc.cm.server.functionSteps.InPDCServerMeasuringFunctionStep;
import com.ibm.cognos.pdc.core.PDCBackendException;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.core.RemoveOperation;
import com.ibm.cognos.pdc.core.SizeStatisticsPutOperation;
import com.ibm.cognos.pdc.core.WriteOperation;
import com.ibm.cognos.pdc.local.BackendGrid;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.xml.sax.SAXException;

public class CommitFunctionStep
extends InPDCServerMeasuringFunctionStep {
    private static ServerSerializer serializer = new ServerSerializer();
    private static ServerDeserializer deserializer = new ServerDeserializer();
    private CMPDCGridManager gridManager;
    private String gridID_;
    protected Map<String, CMServerMapChange> mapChanges = new HashMap<String, CMServerMapChange>();
    private XMLElement stepSpecification;

    public CommitFunctionStep(String name, String id, CustomFunctionPlugin customSessionCommit, XMLElement stepSpecification) {
        this(name, id, customSessionCommit, stepSpecification, null);
    }

    protected CommitFunctionStep(String name, String id, CustomFunctionPlugin customSessionCommit, XMLElement stepSpecification, CMPDCGridManager manager) {
        super(name, id, customSessionCommit);
        this.gridManager = manager == null ? CMPDCGridManager.get() : manager;
        this.stepSpecification = stepSpecification;
    }

    protected void parse() throws CMException {
        this.gridID_ = this.stepSpecification.getChildValueWithName("gridID");
        try {
            XMLElement opsElem = this.stepSpecification.getChildWithName("operations");
            ArrayList ops = opsElem.getChildren();
            for (XMLElement opElem : ops) {
                this.processOperationElement(opElem);
            }
        }
        catch (SerializationException e) {
            throw new CMException((Exception)((Object)e));
        }
    }

    private CMServerMapChange getMapChange(String mapId) {
        CMServerMapChange change = this.mapChanges.get(mapId);
        if (change == null) {
            change = new CMServerMapChange(mapId);
            this.mapChanges.put(mapId, change);
        }
        return change;
    }

    private void processOperationElement(XMLElement opElem) throws CMException, SerializationException {
        String opName = opElem.getChildNonNullValueWithName("name");
        XMLElement arguments = opElem.getChildWithName("arguments");
        String mapID = arguments.getChildNonNullValueWithName("mapID");
        XMLElement keyElement = arguments.getChildWithName("key");
        XMLElement valueElement = keyElement.getChild(0);
        if (valueElement == null) {
            throw new SerializationException("Error parsing customFunction step. Element \"key\" is missing mandatory child.");
        }
        ServerDeserializer.KeySizeCounter keyCounter = new ServerDeserializer.KeySizeCounter();
        Object key = deserializer.deserialize(valueElement, keyCounter);
        Object firstReadValue = null;
        XMLElement firstReadEle = arguments.getOptionalChildWithName("firstReadValue");
        if (firstReadEle != null) {
            firstReadValue = deserializer.deserializeValueElement(firstReadEle);
        }
        RemoveOperation operation = null;
        if (opName.equals("put")) {
            XMLElement valueEle = arguments.getChildWithName("value");
            ServerDeserializer.SizeCounter valueCounter = new ServerDeserializer.SizeCounter();
            Object value = deserializer.deserializeValueElement(valueEle, valueCounter);
            long valueSize = keyCounter.getSecondaryKeySize() + valueCounter.getSize();
            operation = new SizeStatisticsPutOperation(key, value, firstReadValue, keyCounter.getPrimaryKeySize(), valueSize);
        } else if (opName.equals("remove")) {
            operation = new RemoveOperation(key, firstReadValue);
        } else {
            throw new IllegalArgumentException("Invalid operation: " + opName);
        }
        CMServerMapChange change = this.getMapChange(mapID);
        change.addWriteOperation((WriteOperation)operation);
    }

    @Override
    public void runFunctionStepImpl(OutputStream os) throws SAXException, CMException {
        this.parse();
        BackendGrid backend = this.gridManager.getBackendForGrid(this.getGridID());
        try {
            backend.commit(new ArrayList<CMServerMapChange>(this.mapChanges.values()));
        }
        catch (PDCBackendException e) {
            PDCLogging.PDC_ERROR.log(Level.WARNING, e.getLocalizedMessage(), e);
            serializer.serialize(new PrintStream(os), (Exception)((Object)e));
        }
    }

    public String getGridID() {
        return this.gridID_;
    }
}

