/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server.functionSteps;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.ibm.cognos.pdc.cm.SerializationException;
import com.ibm.cognos.pdc.cm.server.CMPDCGridManager;
import com.ibm.cognos.pdc.cm.server.ServerDeserializer;
import com.ibm.cognos.pdc.cm.server.ServerSerializer;
import com.ibm.cognos.pdc.cm.server.functionSteps.InPDCServerMeasuringFunctionStep;
import com.ibm.cognos.pdc.core.PDCBackendException;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.local.BackendGrid;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import org.xml.sax.SAXException;

public class GetFunctionStep
extends InPDCServerMeasuringFunctionStep {
    private static ServerSerializer serializer = new ServerSerializer();
    private static ServerDeserializer deserializer = new ServerDeserializer();
    private CMPDCGridManager gridManager;
    private String gridID_;
    private Object key_;
    private String mapID_;
    private CMIndentedPrintStream out;
    private XMLElement stepSpecification;

    public GetFunctionStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification) {
        this(name, id, plugin, stepSpecification, null);
    }

    protected GetFunctionStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification, CMPDCGridManager gridManager) {
        super(name, id, plugin);
        this.stepSpecification = stepSpecification;
        this.gridManager = gridManager == null ? CMPDCGridManager.get() : gridManager;
    }

    protected void parse() throws CMException {
        this.gridID_ = this.stepSpecification.getChildValueWithName("gridID");
        this.mapID_ = this.stepSpecification.getChildValueWithName("mapID");
        XMLElement keyElement = this.stepSpecification.getChildWithName("key");
        XMLElement valueElement = keyElement.getChild(0);
        if (valueElement == null) {
            throw new CMException("Error parsing customFunction step. Element \"key\" is missing mandatory child.");
        }
        try {
            this.key_ = deserializer.deserialize(valueElement);
        }
        catch (SerializationException ex) {
            throw new CMException((Exception)((Object)ex));
        }
    }

    @Override
    public void runFunctionStepImpl(OutputStream os) throws SAXException, CMException {
        this.parse();
        this.out = new CMIndentedPrintStream(os);
        try {
            Object result = this.getSessionData();
            this.out.print("<result>");
            serializer.serialize((PrintStream)this.out, result);
            this.out.print("</result>");
        }
        catch (PDCBackendException e) {
            PDCLogging.PDC_ERROR.log(Level.WARNING, e.getLocalizedMessage(), e);
            serializer.serialize((PrintStream)this.out, (Exception)((Object)e));
        }
    }

    protected Object getSessionData() throws PDCBackendException {
        BackendGrid backend = this.gridManager.getBackendForGrid(this.getGridID());
        return backend.get(this.getMapID(), this.getKey());
    }

    public String getGridID() {
        return this.gridID_;
    }

    public String getMapID() {
        return this.mapID_;
    }

    public Object getKey() {
        return this.key_;
    }
}

