/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server.functionSteps;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.ibm.cognos.pdc.BackingMap;
import com.ibm.cognos.pdc.cm.server.CMPDCGridManager;
import com.ibm.cognos.pdc.cm.server.CMServerEvictorSerializer;
import com.ibm.cognos.pdc.cm.server.functionSteps.InPDCServerMeasuringFunctionStep;
import com.ibm.cognos.pdc.core.eviction.EvictionTriggers;
import com.ibm.cognos.pdc.local.BackendGrid;
import java.io.OutputStream;
import java.util.List;
import org.xml.sax.SAXException;

public class GetGridConfigurationStep
extends InPDCServerMeasuringFunctionStep {
    protected static CMServerEvictorSerializer evictorSerializer = new CMServerEvictorSerializer();
    private CMPDCGridManager gridManager;
    private XMLElement stepSpecification;
    private String gridId;

    public GetGridConfigurationStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification) {
        this(name, id, plugin, stepSpecification, null);
    }

    protected GetGridConfigurationStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification, CMPDCGridManager manager) {
        super(name, id, plugin);
        this.stepSpecification = stepSpecification;
        this.gridManager = manager == null ? CMPDCGridManager.get() : manager;
    }

    @Override
    public void runFunctionStepImpl(OutputStream os) throws SAXException, CMException {
        this.parse();
        CMIndentedPrintStream out = new CMIndentedPrintStream(os);
        out.println();
        out.indent();
        out.println("<result>");
        out.indent();
        BackendGrid grid = this.gridManager.getBackendForGrid(this.gridId);
        out.print("<grid id=\"" + this.gridId + "\" configurationState=\"");
        if (grid != null) {
            out.println("configured\" >");
            this.outputGridConfiguration(out, grid);
            out.unindent();
            out.println("</grid>");
        } else {
            out.println("unconfigured\" />");
        }
        out.unindent();
        out.println("</result>");
    }

    private void outputGridConfiguration(CMIndentedPrintStream out, BackendGrid grid) {
        List maps = grid.getBackingMaps();
        for (BackingMap map : maps) {
            out.println("<map id=\"" + map.getMapName() + "\">");
            out.indent();
            this.outputEvictionTriggers(out, map);
            this.outputEvictor(out, map);
            out.unindent();
            out.println("</map>");
        }
    }

    private void outputEvictor(CMIndentedPrintStream out, BackingMap map) {
        evictorSerializer.serializeEvictor(out, map.getEvictor());
    }

    private void outputEvictionTriggers(CMIndentedPrintStream out, BackingMap map) {
        out.println("<evictionTriggers>");
        out.indent();
        for (EvictionTriggers trigger : map.getEvictionTriggers()) {
            out.println("<evictionTrigger>" + trigger.toString() + "</evictionTrigger>");
        }
        out.unindent();
        out.println("</evictionTriggers>");
    }

    private void parse() throws CMException {
        this.gridId = this.stepSpecification.getChildValueWithName("gridID");
    }
}

