/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server.functionSteps;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomFunctionStep;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.ibm.cognos.pdc.cm.server.CMPDCGridManager;
import com.ibm.cognos.pdc.local.BackendGrid;
import java.io.OutputStream;
import java.util.List;
import org.xml.sax.SAXException;

public class ListGridsFunctionStep
extends CustomFunctionStep {
    private CMPDCGridManager gridManager;

    public ListGridsFunctionStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification) {
        this(name, id, plugin, stepSpecification, null);
    }

    protected ListGridsFunctionStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification, CMPDCGridManager manager) {
        super(name, id, plugin);
        this.gridManager = manager == null ? CMPDCGridManager.get() : manager;
    }

    public void runFunctionStep(OutputStream out) throws SAXException, CMException {
        CMIndentedPrintStream stream = new CMIndentedPrintStream(out);
        stream.println();
        stream.indent();
        stream.println("<result>");
        stream.indent();
        List<String> grids = this.gridManager.getGridIds();
        for (String gridId : grids) {
            stream.println("<grid id=\"" + gridId + "\">");
            stream.indent();
            BackendGrid grid = this.gridManager.getBackendForGrid(gridId);
            List maps = grid.getMapNames();
            for (String map : maps) {
                stream.print("<map id=\"" + map + "\" />");
            }
            stream.unindent();
            stream.println("</grid>");
        }
        stream.unindent();
        stream.println("</result>");
        stream.unindent();
    }
}

