/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server.functionSteps;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomFunctionStep;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.ibm.cognos.pdc.cm.server.CMPDCGridManager;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.local.BackendGrid;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class ListMapsFunctionStep
extends CustomFunctionStep {
    private CMPDCGridManager gridManager;
    private List<String> gridIds = new ArrayList<String>();

    public ListMapsFunctionStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification) throws CMException {
        this(name, id, plugin, stepSpecification, null);
    }

    protected ListMapsFunctionStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification, CMPDCGridManager manager) throws CMException {
        super(name, id, plugin);
        this.gridManager = manager == null ? CMPDCGridManager.get() : manager;
        this.parse(stepSpecification);
    }

    private void parse(XMLElement stepSpecification) throws CMException {
        ArrayList children = stepSpecification.getChildren();
        for (XMLElement child : children) {
            if (!child.name_.equals("grid")) continue;
            String gridId = child.getAttribute("id");
            if (gridId == null) {
                throw (CMException)PDCLogging.logAndReturnException((Logger)PDCLogging.PDC_ERROR, (Level)Level.WARNING, (Exception)new CMException("cmExpectedAttributeMissing", new CMException.Parm[]{new CMException.Parm("Name", "id"), new CMException.Parm("Element", "grid")}));
            }
            this.gridIds.add(gridId);
        }
    }

    public void runFunctionStep(OutputStream out) throws SAXException, CMException {
        CMIndentedPrintStream stream = new CMIndentedPrintStream(out);
        stream.println();
        stream.indent();
        stream.println("<result>");
        stream.indent();
        for (String gridId : this.gridIds) {
            BackendGrid grid = this.gridManager.getBackendForGrid(gridId);
            if (grid == null) continue;
            stream.println("<grid id=\"" + gridId + "\">");
            stream.indent();
            List maps = grid.getMapNames();
            for (String map : maps) {
                stream.print("<map id=\"" + map + "\" />");
            }
            stream.unindent();
            stream.println("</grid>");
        }
        stream.unindent();
        stream.println("</result>");
        stream.unindent();
    }
}

