/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server.functionSteps;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomFunctionStep;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.ibm.cognos.pdc.cm.SerializationException;
import com.ibm.cognos.pdc.cm.server.CMPDCGridManager;
import com.ibm.cognos.pdc.cm.server.ResponseGeneratingGridVisitor;
import com.ibm.cognos.pdc.cm.server.ServerDeserializer;
import com.ibm.cognos.pdc.core.PDCLogging;
import com.ibm.cognos.pdc.local.BackendGrid;
import com.ibm.cognos.pdc.local.BackendGridVisitor;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class ViewDataFunctionStep
extends CustomFunctionStep {
    private CMPDCGridManager gridManager;
    private static ServerDeserializer deserializer = new ServerDeserializer();
    private Map<String, Set<String>> grid2Maps = new HashMap<String, Set<String>>();
    private List<Object> keyFilters;

    public ViewDataFunctionStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification) throws CMException {
        this(name, id, plugin, stepSpecification, null);
    }

    protected ViewDataFunctionStep(String name, String id, CustomFunctionPlugin plugin, XMLElement stepSpecification, CMPDCGridManager manager) throws CMException {
        super(name, id, plugin);
        this.gridManager = manager == null ? CMPDCGridManager.get() : manager;
        this.parse(stepSpecification);
    }

    private void parse(XMLElement stepSpecification) throws CMException {
        this.parseViewData(stepSpecification);
        this.parseFilters(stepSpecification);
    }

    private void parseViewData(XMLElement stepSpecification) throws CMException {
        XMLElement gridsElement = stepSpecification.getChildWithName("grids");
        ArrayList grids = gridsElement.getChildren();
        for (XMLElement grid : grids) {
            if (!grid.nameIs("grid")) continue;
            String gridId = grid.getAttribute("id");
            if (gridId == null) {
                throw (CMException)PDCLogging.logAndReturnException((Logger)PDCLogging.PDC_ERROR, (Level)Level.WARNING, (Exception)new CMException("cmExpectedAttributeMissing", new CMException.Parm[]{new CMException.Parm("Name", "id"), new CMException.Parm("Element", "grid")}));
            }
            HashSet<String> maps = new HashSet<String>();
            if (grid.hasChildren()) {
                ArrayList mapIds = grid.getChildren();
                for (XMLElement mapElement : mapIds) {
                    if (!mapElement.nameIs("map")) continue;
                    String mapId = mapElement.getAttribute("id");
                    if (mapId == null) {
                        throw (CMException)PDCLogging.logAndReturnException((Logger)PDCLogging.PDC_ERROR, (Level)Level.WARNING, (Exception)new CMException("cmExpectedAttributeMissing", new CMException.Parm[]{new CMException.Parm("Name", "id"), new CMException.Parm("Element", "map")}));
                    }
                    maps.add(mapId);
                }
            }
            this.grid2Maps.put(gridId, maps);
        }
    }

    private void parseFilters(XMLElement stepSpecification) throws CMException {
        XMLElement filterBy = stepSpecification.getOptionalChildWithName("filterBy");
        if (filterBy != null && filterBy.hasChildren()) {
            this.keyFilters = new ArrayList<Object>();
            ArrayList filters = filterBy.getChildren();
            for (XMLElement filter : filters) {
                if (!filter.nameIs("key")) continue;
                try {
                    this.keyFilters.add(deserializer.deserializeValueElement(filter));
                }
                catch (SerializationException e) {
                    throw new CMException(PDCLogging.logAndReturnException((Logger)PDCLogging.PDC_ERROR, (Level)Level.WARNING, (Exception)((Object)e)));
                }
            }
        }
    }

    public void runFunctionStep(OutputStream out) throws SAXException, CMException {
        CMIndentedPrintStream stream = new CMIndentedPrintStream(out);
        ResponseGeneratingGridVisitor visitor = new ResponseGeneratingGridVisitor(stream, this.keyFilters, this.grid2Maps);
        stream.println();
        stream.indent();
        stream.println("<result>");
        stream.indent();
        for (Map.Entry<String, Set<String>> gridEntry : this.grid2Maps.entrySet()) {
            String gridId = gridEntry.getKey();
            BackendGrid grid = this.gridManager.getBackendForGrid(gridId);
            if (grid == null) continue;
            grid.acceptVisitor((BackendGridVisitor)visitor);
        }
        stream.unindent();
        stream.println("</result>");
        stream.unindent();
    }
}

